import 'package:flutter/cupertino.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../api/api.dart';
import '../helper/helper.dart';
import 'filter_menu.dart';

class BranchExist extends Cubit<String> {
  BranchExist() : super(responseApiWaiting);

  Future<String> getBranch(String branchCode, String brandCode, String role,
      String cashierName, String orderId) async {
    var apiGetBranch =
        await Api.getBranch(branchCode, brandCode, role, cashierName, orderId);
    return apiGetBranch;
  }

  void branchExist(String branchCode, String brandCode, String role,
      String cashierName, String orderId, BuildContext context,
      {bool getMenu = false}) {
    getBranch(branchCode, brandCode, role, cashierName, orderId).then((value) {
      if (getMenu) {
        context
            .read<FilterMenuBloc>()
            .catAndMenu(branchCode, brandCode, role, cashierName, orderId);
      }

      emit(value);
    });
  }
}
