import 'package:byod/helper/helper.dart';

import '../main.dart';

const String _orderId = 'order_id';
const String _secretKey = 'secret_key';
const String _sessionCounter = 'session_counter';
const String _sessionId = 'session_id';
const String _baseUrl = 'baseUrl';
const String _tableNumber = 'table_number';
const String _tableMode = 'table_mode';
const String _customerName = 'userName';
const String _totalOrder = 'total_order';
const String _dateOrder = 'date_order';
const String _branch = 'outlet';
const String _brand = 'brand';
const String _token = 'token';
const String _listHistory = 'list_history';
const String _logo = 'logo';
const String _role = 'role';
const String _cashierName = 'cashier_name';

String getBaseUrl() {
  return prefs.getString(_baseUrl) ?? '';
}

Future<void> setBaseUrl(String value) async {
  prefs.setString(_baseUrl, value);
}

String getOrderId() {
  return prefs.getString(_orderId) ?? '';
}

Future<void> setOrderId(String value) async {
  prefs.setString(_orderId, value);
}

String getSecretKey() {
  return prefs.getString(_secretKey) ?? '';
}

Future<void> setSecretKey(String value) async {
  prefs.setString(_secretKey, value);
}

int getSessionCounter() {
  return prefs.getInt(_sessionCounter) ?? 0;
}

Future<void> setSessionCounter(int value) async {
  prefs.setInt(_sessionCounter, value);
}

Future<void> setSessionCounterPlus(int value) async {
  prefs.setInt(_sessionCounter, value + 1);
}

String getSessionId() {
  return prefs.getString(_sessionId) ?? '';
}

Future<void> setSesssionId(String value) async {
  prefs.setString(_sessionId, value);
}

String getTabelNumber() {
  return prefs.getString(_tableNumber) ?? '';
}

Future<void> setTableNumber(String value) async {
  prefs.setString(_tableNumber, value);
}

String getCustomerName() {
  return prefs.getString(_customerName) ?? '';
}

Future<void> setCustomerName(String value) async {
  prefs.setString(_customerName, value);
}

String getTotalOrder() {
  return prefs.getString(_totalOrder) ?? '';
}

Future<void> setTotalOrder(String value) async {
  prefs.setString(_totalOrder, value);
}

String getOrderDate() {
  return prefs.getString(_dateOrder) ?? '';
}

Future<void> setOrderDate(String value) async {
  prefs.setString(_dateOrder, value);
}

String getBranchPref() {
  return prefs.getString(_branch) ?? '';
}

Future<void> setBranch(String value) async {
  prefs.setString(_branch, value);
}

String getBrand() {
  return prefs.getString(_brand) ?? '';
}

Future<void> setBrand(String value) async {
  prefs.setString(_brand, value);
}

String getToken() {
  return prefs.getString(_token) ?? '';
}

Future<void> setToken(String value) async {
  prefs.setString(_token, value);
}

List<String> getListHistory() {
  return prefs.getStringList(_listHistory) ?? [];
}

Future<void> setListHistory(List<String> value) async {
  prefs.setStringList(_listHistory, value);
}

int getTableMode() {
  return prefs.getInt(_tableMode) ?? defaultBillTable;
}

Future<void> setTableMode(int value) async {
  prefs.setInt(_tableMode, value);
}

String getLogoUrl() {
  return prefs.getString(_logo) ?? '';
}

Future<void> setLogoUrl(String value) async {
  prefs.setString(_logo, value);
}

String getRole() {
  return prefs.getString(_role) ?? 'customer';
}

Future<void> setRole(String value) async {
  prefs.setString(_role, value);
}

String getCashierName() {
  return prefs.getString(_cashierName) ?? '';
}

Future<void> setCashierName(String value) async {
  prefs.setString(_cashierName, value);
}
