import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../bloc/order_bloc.dart';
import '../../bloc/order_variant_temporary.dart';
import '../../helper/helper.dart';
import '../../helper/widget/style.dart';
import '../../models/filter_menu.dart';
import '../../models/order_details.dart';
import '../../models/orders.dart';
import 'bottom_sheet_variant.dart';
import 'variant_cat.dart';

class ShowMenuBottomSheet extends StatelessWidget {
  const ShowMenuBottomSheet({
    Key? key,
    required this.menuDetail,
    required this.i,
    required this.widthScreen,
    required this.widthImage,
  }) : super(key: key);

  final List<FilterMenu> menuDetail;
  final int i;
  final double widthScreen;
  final double widthImage;

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<OrdersBloc, List<Orders>>(
      builder: (context, list) {
        int indexListOrderan = list
            .indexWhere((listOrderan) => listOrderan.id == menuDetail[i].id);
        int initialValue;
        if (indexListOrderan != -1) {
          initialValue = list[indexListOrderan].totalItem;
        } else {
          initialValue = 0;
        }
        return Container(
          padding: const EdgeInsets.symmetric(horizontal: paddingLeftRight),
          width: widthScreen,
          child: Column(
            mainAxisSize: MainAxisSize.min,
            children: [
              Container(
                margin: const EdgeInsets.only(top: 8, bottom: 32),
                width: 50,
                height: 3,
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(7),
                  color: greyColor,
                ),
              ),
              Align(
                alignment: Alignment.centerLeft,
                child: textMenuNameBottomShetModalMenu(
                    context, menuDetail[i].name),
              ),
              const SizedBox(
                height: 30,
              ),
              ClipRRect(
                borderRadius: BorderRadius.circular(21),
                child: (menuDetail[i].imageUrlMedium != '')
                    ? Image(
                        width: widthImage,
                        height: widthImage,
                        image: NetworkImage(
                          menuDetail[i].imageUrlMedium,
                        ),
                      )
                    : Image(
                        width: widthImage,
                        height: widthImage,
                        image: const AssetImage(
                          'assets/noimage.png',
                        ),
                      ),
              ),
              const SizedBox(
                height: 20,
              ),
              (menuDetail[i].description != '')
                  ? Align(
                      alignment: Alignment.centerLeft,
                      child: defaultText(
                        context,
                        'Deskripsi',
                        style: textDeskripsiHeader(),
                      ),
                    )
                  : const SizedBox(),
              const SizedBox(
                height: 12,
              ),
              Align(
                alignment: Alignment.centerLeft,
                child: defaultText(
                  context,
                  menuDetail[i].description,
                  maxLines: 5,
                  overFlow: TextOverflow.ellipsis,
                  style: textDeskripsi(),
                ),
              ),
              const SizedBox(
                height: 12,
              ),
              Container(
                padding: const EdgeInsets.only(bottom: 18),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    defaultText(
                      context,
                      'Rp ${formatNumber().format(amountParseToInt(menuDetail[i].price))}',
                      style: amountMenuStyle(
                          font: 20, fontWeight: FontWeight.w500),
                    ),
                    GestureDetector(
                      onTap: () {
                        if (menuDetail[i].isSell) {
                          if (menuDetail[i].variantCat.isNotEmpty) {
                            if (indexListOrderan == -1) {
                              Navigator.pop(context);
                              context
                                  .read<OrderVariantTemporaryBloc>()
                                  .insertDataVariant(
                                      menuDetail[i].id,
                                      amountParseToInt(menuDetail[i].price),
                                      1,
                                      []); // check pada bloc untuk mengethui list arraynya
                              Navigator.push(
                                  context,
                                  MaterialPageRoute(
                                      builder: (_) => VariantCat(
                                            namaMenu: menuDetail[i].name,
                                            variantCategories:
                                                menuDetail[i].variantCat,
                                            initPrice: amountParseToInt(
                                                menuDetail[i].price),
                                            idItem: menuDetail[i].id,
                                            imageUrl:
                                                menuDetail[i].imageUrlMedium,
                                            listCurrentOrder: list,
                                            orderDetail: OrderDetail(
                                                allIdVariant: '',
                                                totalItem: 0,
                                                totalHarga: 0,
                                                note: '',
                                                orderVariant: []),
                                          )));
                            } else {
                              Navigator.pop(context);
                              showModalBottomSheet(
                                backgroundColor: Colors.white.withOpacity(0),
                                isScrollControlled: true,
                                context: context,
                                builder: (context) {
                                  return CustomizeVariant(
                                      orders: list[indexListOrderan],
                                      variantCat: menuDetail[i].variantCat);
                                },
                              );
                            }
                          } else {
                            initialValue += 1;
                            Map<String, dynamic> insertData = {
                              'menu_id': menuDetail[i].id,
                              'menu_name': menuDetail[i].name,
                              'initvalue': initialValue,
                              'menu_price':
                                  amountParseToInt(menuDetail[i].price),
                              'total_price':
                                  amountParseToInt(menuDetail[i].price),
                              'old_order': list,
                              'image_url': menuDetail[i].imageUrlMedium,
                              'order_variant': [],
                              'note': (indexListOrderan != -1)
                                  ? list[indexListOrderan].note
                                  : '',
                            };
                            context.read<OrdersBloc>().insertData(insertData);
                            Navigator.pop(context);
                          }
                        }
                      },
                      child: Container(
                        height: 38,
                        width: 119,
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(6),
                          color: buttonColor,
                        ),
                        child: Center(
                          child: defaultText(
                            context,
                            'Tambah',
                            style: addButton(),
                          ),
                        ),
                      ),
                    )
                  ],
                ),
              ),
            ],
          ),
        );
      },
    );
  }
}
