// ignore_for_file: must_be_immutable

import 'package:flutter/material.dart';

import '../helper/helper.dart';

class ScreenResponsive extends StatefulWidget {
  Widget widget;
  double widthScreen;
  bool isCoreLayout;
  ScreenResponsive({
    Key? key,
    required this.widget,
    required this.widthScreen,
    required this.isCoreLayout,
  }) : super(key: key);

  @override
  State<ScreenResponsive> createState() => _ScreenResponsiveState();
}

class _ScreenResponsiveState extends State<ScreenResponsive> {
  @override
  Widget build(BuildContext context) {
    double maxWidthScreen = getMaxWidthScreen(context, useResponsive);
    if (widget.widthScreen > maxWidthScreen) {
      double leftRight = (widget.widthScreen - maxWidthScreen) / 2;
      if (widget.isCoreLayout) {
        return Row(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            Container(
              width: leftRight,
              height: MediaQuery.of(context).size.height,
              color: responsiveLeftRigth,
            ),
            widget.widget,
            Container(
              width: leftRight,
              height: MediaQuery.of(context).size.height,
              color: responsiveLeftRigth,
            )
          ],
        );
      } else {
        return Center(
          child: widget.widget,
        );
      }
    } else {
      return widget.widget;
    }
  }
}
