import 'package:flutter_bloc/flutter_bloc.dart';

import '../api/api.dart';
import '../helper/helper.dart';

class BranchExist extends Cubit<String> {
  BranchExist() : super(responseApiWaiting);

  Future<String> getBranch(String branchCode, String brandCode, String role,
      String cashierName, String sessionId) async {
    var apiGetBranch = await Api.getBranch(
        branchCode, brandCode, role, cashierName, sessionId);
    return apiGetBranch;
  }

  void branchExist(String branchCode, String brandCode, String role,
      String cashierName, String sessionId) {
    getBranch(branchCode, brandCode, role, cashierName, sessionId)
        .then((value) {
      emit(value);
    });
  }
}
