import 'package:flutter_bloc/flutter_bloc.dart';

class SearchHistory extends Cubit<List<String>> {
  SearchHistory() : super(['start']);

  void search(List<String> historyOrder, String keyword) {
    if (keyword == '') {
      emit(historyOrder);
    } else {
      List<String> result = [];
      for (var history in historyOrder) {
        if (history.toLowerCase().contains(keyword.toLowerCase())) {
          result.add(history);
        }
      }
      emit(result);
    }
  }
}
