// import 'package:byod/models/category.dart';
// import 'package:flutter_bloc/flutter_bloc.dart';

// import '../models/menu.dart';

// class SearchMenu extends Cubit<List<Menu>> {
//   SearchMenu() : super([]);

//   void searchMenu(List<Category> oldCategory, String keyword) {
//     List<Menu> searchMenu = [];
//     if (keyword.isNotEmpty) {
//       for (var cat in oldCategory) {
//         for (var menu in cat.menu) {
//           if (menu.name.toLowerCase().contains(keyword.toLowerCase())) {
//             searchMenu.add(menu);
//           }
//         }
//       }
//     }
//     emit(searchMenu);
//   }
// }

import 'package:byod/helper/helper.dart';
import 'package:byod/models/filter_menu.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class SearchMenu extends Cubit<List<dynamic>> {
  SearchMenu()
      : super([
          [
            FilterMenu(
              id: 'start',
              name: '',
              price: '',
              originalPrice: '',
              imageUrlMedium: '',
              imageUrlThumbnail: '',
              isSell: false,
              type: typeMenu,
              categoryName: '',
              categoryId: '',
              description: '',
              groupName: '',
              groupId: '',
            )
          ],
          'All',
          false
        ]);
  // return arraynya [list<Category>, SelectedCat, bool dari search by text(typing) or not,]

  void searchMenu(
    List<FilterMenu> oldMenu, {
    String keyword = '',
    String categorySelected = 'All',
    isSearch = false,
  }) {
    List<FilterMenu> searchMenu = [];
    if (isSearch) {
      if (keyword.isNotEmpty) {
        for (var x in oldMenu) {
          if (x.name.toLowerCase().contains(keyword.toLowerCase())) {
            int indexCat = oldMenu.indexWhere(
              (cat) =>
                  cat.type == typeCategory &&
                  cat.categoryName == x.categoryName,
            );
            int indexCheckCatName = searchMenu.indexWhere(
              (cat) =>
                  cat.type == typeCategory &&
                  cat.categoryName == x.categoryName,
            );
            if (indexCheckCatName == -1 && indexCat != -1) {
              searchMenu.add(oldMenu[indexCat]);
            }

            int indexGroup = oldMenu.indexWhere(
              (group) => group.type == typeGroup && group.groupId == x.groupId,
            );
            int indexGroupId = searchMenu.indexWhere(
              (group) => group.type == typeGroup && group.groupId == x.groupId,
            );
            if (indexGroupId == -1 && indexGroup != -1) {
              searchMenu.add(oldMenu[indexGroup]);
            }
            searchMenu.add(x);
          }
        }
      } else {
        searchMenu = oldMenu;
      }
    } else {
      if (categorySelected != '') {
        if (categorySelected == 'All') {
          searchMenu = oldMenu;
        } else {
          for (var x in oldMenu) {
            if (x.categoryName == categorySelected) {
              // int indexCat = oldMenu.indexWhere(
              //   (cat) =>
              //       cat.type == typeCategory &&
              //       cat.categoryName == categorySelected,
              // );
              // searchMenu.add(oldMenu[indexCat]);
              searchMenu.add(x);
            }
          }
        }
      }
    }
    emit([searchMenu, categorySelected, isSearch]);
  }
}
