// ignore_for_file: sized_box_for_whitespace

import 'package:byod/helper/widget/style.dart';
import 'package:flutter/material.dart';

import '../helper.dart';

Future<dynamic> buttonDialogGlobal(
    BuildContext context,
    String title,
    String description,
    String textOnOk,
    String textOnCancel,
    void Function() ontapOk,
    void Function() ontapCancel,
    {Color okButtonColor = Colors.indigo,
    Color cancelButtonColor = Colors.red}) {
  return showDialog(
      context: context,
      builder: (BuildContext context) => AlertDialog(
            // title: Text(
            //   textScaleFactor: textScaleFactor,
            //   title,
            //   style: textStyleNormalFont(context),
            // ),
            title: defaultText(
              context,
              title,
              // style: textStyleNormalFont(context),
            ),
            content: Column(
              mainAxisSize: MainAxisSize.min,
              children: [
                Align(
                  alignment: Alignment.topLeft,
                  child: defaultText(
                    context,
                    description,
                    style: textStyleNormalFont(context),
                  ),
                ),
                const SizedBox(height: 10),
                GestureDetector(
                  onTap: () {
                    ontapOk();
                  },
                  child: Container(
                    width: double.infinity,
                    height: 40,
                    decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(roundedButton),
                        color: okButtonColor),
                    child: Center(
                      child: defaultText(
                        context,
                        textOnOk,
                        style: textStyleNormalFont(
                          context,
                          color: textInButton,
                        ),
                      ),
                    ),
                  ),
                ),
                const SizedBox(height: 10),
                GestureDetector(
                  onTap: () {
                    ontapCancel();
                  },
                  child: Container(
                    width: double.infinity,
                    height: 40,
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(roundedButton),
                      color: Colors.transparent,
                    ),
                    child: Center(
                      child: defaultText(
                        context,
                        textOnCancel,
                        style: textStyleNormalFont(
                          context,
                          color: textCancelColor,
                        ),
                      ),
                    ),
                  ),
                )
              ],
            ),
          ));
}
