// ignore_for_file: must_be_immutable

import 'package:byod/helper/widget/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../api/api.dart';
import '../../bloc/order_bloc.dart';
import '../../bloc/view_bill.dart';
import '../../models/filter_menu.dart';
import '../../models/order_variants.dart';
import '../../models/orders.dart';
import '../helper.dart';

class NoteModalBottomSheet extends StatelessWidget {
  NoteModalBottomSheet({
    Key? key,
    required this.noteController,
    required this.initialValue,
    required this.orderVariants,
    required this.menuItem,
    required this.lisrOrders,
    required this.from,
    this.idOrderan = '',
    this.noteInit = '',
    required this.contextFrom,
  }) : super(key: key);

  late TextEditingController noteController;
  final int initialValue;
  final List<OrderVariant> orderVariants;
  final FilterMenu menuItem;
  final List<Orders> lisrOrders;
  final String from;
  final String idOrderan;
  final String noteInit;
  final BuildContext contextFrom;

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.symmetric(horizontal: 20),
      height: MediaQuery.of(context).size.height * 0.9,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Container(
            margin: const EdgeInsets.only(
              top: 20,
              bottom: 20,
            ),
            child: defaultText(
              context,
              'catatan untuk pesanan',
              style: textHeaderNote(),
            ),
          ),
          const Divider(
            thickness: 2,
            color: Colors.white,
          ),
          TextField(
            maxLength: maxLengthTextField,
            maxLines: 5,
            autofocus: true,
            keyboardType: TextInputType.text,
            controller: noteController,
            style: noteModal(),
            decoration: InputDecoration(
              border: InputBorder.none,
              hintText: placeHolderNote,
              hintStyle: const TextStyle(
                color: Colors.grey,
                fontFamily: 'OpenSans',
                fontSize: 14,
              ),
            ),
          ),
          const Divider(
            thickness: 2,
            color: Colors.white,
          ),
          const SizedBox(
            height: 20,
          ),
          GestureDetector(
            onTap: () {
              if (from == fromMenu) {
                context.read<OrdersBloc>().insertData([
                  [
                    menuItem.id,
                    menuItem.name,
                    initialValue,
                    amountParseToInt(menuItem.price),
                    lisrOrders,
                    menuItem.imageUrlMedium,
                    orderVariants,
                    amountParseToInt(menuItem.price),
                    noteController.text
                  ]
                ], context);
              } else if (from == fromBill) {
                if (idOrderan != '') {
                  Api.changeOrderDetail(
                    contextFrom,
                    idOrderan,
                    initialValue,
                    noteController.text,
                  ).then((value) {
                    context.read<ViewBillBloc>().getBill();
                  });
                }
              }
              Navigator.pop(context);
            },
            child: Align(
              alignment: Alignment.centerRight,
              child: Container(
                height: 36,
                width: 89,
                decoration: BoxDecoration(
                  color: buttonColor,
                  borderRadius: BorderRadius.circular(21),
                ),
                child: Center(
                  child: defaultText(
                    context,
                    "Simpan",
                    style: simpanButtonNote(),
                  ),
                ),
              ),
            ),
          )
        ],
      ),
    );
  }
}
