// ignore_for_file: sized_box_for_whitespace

import 'package:byod/helper/widget/style.dart';
import 'package:flutter/material.dart';

import '../helper.dart';

class PlusMinusButton extends StatelessWidget {
  const PlusMinusButton({
    Key? key,
    required this.initialValue,
    required this.minus,
    required this.plus,
    this.backgroundAmountColor = backgroundColor,
    this.isFromVariant = false,
    this.widthInitialValue = 94,
  }) : super(key: key);

  final int initialValue;
  final void Function() minus;
  final void Function() plus;
  final Color backgroundAmountColor;
  final bool isFromVariant;
  final double widthInitialValue;

  @override
  Widget build(BuildContext context) {
    return Stack(
      children: [
        Container(
          width: widthInitialValue,
          height: 22,
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(30),
            color: backgroundAmountColor,
          ),
          child: Center(
            child: defaultText(
              context,
              initialValue.toString(),
              style: amountViewBillButton(),
            ),
          ),
        ),
        Positioned(
          left: 0,
          child: GestureDetector(
            onTap: () {
              // if (initialValue > 1) {
              //   initialValue += -1;
              //   context
              //       .read<OrderVariantTemporaryBloc>()
              //       .insertDataVariant(itemId, satuanPrice,
              //           initialValue, []);
              // }
              minus();
            },
            child: Container(
              width: 22,
              height: 22,
              child: Image(
                image: AssetImage((initialValue < 2 && isFromVariant)
                    ? 'assets/icons/minus.png'
                    : 'assets/icons/minus-blue.png'),
              ),
            ),
          ),
        ),
        Positioned(
          right: 0,
          child: GestureDetector(
            onTap: () {
              // initialValue += 1;
              // context
              //     .read<OrderVariantTemporaryBloc>()
              //     .insertDataVariant(
              //         itemId, satuanPrice, initialValue, []);
              plus();
            },
            child: Container(
              width: 22,
              height: 22,
              child: const Image(
                image: AssetImage('assets/icons/plus.png'),
              ),
            ),
          ),
        )
      ],
    );
  }
}
