import 'package:byod/models/variant_categories.dart';

class FilterMenu {
  final String id;
  final String name;
  final String price;
  final String originalPrice;
  final String imageUrlMedium;
  final String imageUrlThumbnail;
  final bool isSell;
  final int type;
  final String categoryName;
  final String categoryId;
  final String description;
  final String groupName;
  final String groupId;
  List<VariantCategories> variantCat;
  final bool isFavMenu;
  final String favGroupId;
  final String favGroupName;

  FilterMenu({
    required this.id,
    required this.name,
    required this.price,
    required this.originalPrice,
    required this.imageUrlMedium,
    required this.imageUrlThumbnail,
    required this.isSell,
    required this.type,
    required this.categoryName,
    required this.categoryId,
    required this.description,
    required this.groupName,
    required this.groupId,
    this.isFavMenu = false,
    this.variantCat = const [],
    this.favGroupId = '',
    this.favGroupName = '',
  });

  factory FilterMenu.createMenu(Map<String, dynamic> json) {
    return FilterMenu(
      id: json['id'],
      name: json['name'],
      price: json['price'],
      originalPrice: json['original_price'],
      imageUrlMedium: json['image_medium'],
      imageUrlThumbnail: json['image_thumbnail'],
      isSell: json['sold_in_store'],
      type: json['type'],
      categoryName: json['category_name'],
      categoryId: json['category_id'],
      description: json['description'],
      groupName: json['group_name'],
      groupId: json['group_id'],
      isFavMenu: (json['is_fav'] == null) ? false : json['is_fav'],
      variantCat: json['variant_cat'],
      favGroupId:
          (json['favorite_group_id'] == null) ? '' : json['favorite_group_id'],
      favGroupName: (json['favorite_group_name'] == null)
          ? ''
          : json['favorite_group_name'],
    );
  }
}
