class OrderVariant {
  late String categoryId;
  final String id;
  final String name;
  final int price;
  final int type;
  final String caption;

  OrderVariant({
    required this.categoryId,
    required this.id,
    required this.name,
    required this.price,
    required this.type,
    required this.caption,
  });

  factory OrderVariant.createVariant(Map<String, dynamic> json) {
    return OrderVariant(
        categoryId: json['categoryId'],
        id: json['id'],
        name: json['name'],
        price: json['price'],
        type: json['type'],
        caption: json['caption']);
  }
}
