// ignore_for_file: sized_box_for_whitespace

import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import '../../bloc/search_history.dart';
import '../../helper/helper.dart';
import '../../helper/widget/style.dart';

class CustomAppBar extends StatelessWidget {
  CustomAppBar({
    Key? key,
    required this.historyOrder,
  }) : super(key: key);

  final List<String> historyOrder;

  final _searchController = TextEditingController();
  @override
  Widget build(BuildContext context) {
    return Container(
      color: backgroundWhite,
      padding: const EdgeInsets.symmetric(
          horizontal: paddingLeftRight, vertical: 15),
      child: Column(
        children: [
          Row(
            // mainAxisAlignment: MainAxisAlignment.start,
            children: [
              GestureDetector(
                onTap: () {
                  Navigator.pop(context);
                },
                child: Container(
                  width: 24,
                  height: 24,
                  child: Center(
                    child: fontAwesomeNew(
                      arrowBack,
                      arrowBackSize,
                    ),
                  ),
                ),
              ),
              const SizedBox(
                width: 16,
              ),
              Center(
                child: defaultText(
                  context,
                  'Riwayat Transaksi',
                  maxLines: 1,
                  overFlow: TextOverflow.ellipsis,
                  style: appBarNameViewBill(),
                ),
              ),
            ],
          ),
          const SizedBox(
            height: 16,
          ),
          Container(
            height: 36,
            child: TextField(
              controller: _searchController,
              // autofocus: true,
              onChanged: (sarchValue) {
                context.read<SearchHistory>().search(
                      historyOrder,
                      _searchController.text,
                    );
              },
              key: const Key('SearchField'),
              style: TextStyle(
                color: Colors.black,
                fontFamily: fontFamily,
                fontSize: 15,
              ),
              decoration: InputDecoration(
                filled: true,
                fillColor: Colors.white,
                enabledBorder: OutlineInputBorder(
                  borderSide: BorderSide(
                    width: 1,
                    color: Colors.grey.withOpacity(0.8),
                  ),
                ),
                focusedBorder: OutlineInputBorder(
                  borderSide: BorderSide(
                    width: 1,
                    color: buttonColor,
                  ),
                ),
                prefixIcon: Image(
                  image: const AssetImage('assets/icons/search.png'),
                  color: Colors.grey.withOpacity(0.8),
                  height: 20,
                  width: 20,
                ),
                hintText: 'Example: September',
                hintStyle: TextStyle(
                  color: Colors.grey.withOpacity(0.8),
                  fontFamily: fontFamily,
                  fontSize: 10,
                ),
                border: OutlineInputBorder(
                  borderRadius: BorderRadius.circular(6),
                ),
              ),
            ),
          ),
        ],
      ),
    );
  }
}
