// ignore_for_file: sized_box_for_whitespace

import 'dart:convert';

import 'package:byod/helper/helper.dart';
import 'package:byod/helper/widget/style.dart';
import 'package:byod/ui/history_order/app_bar.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../bloc/search_history.dart';
import '../viewbill/view_bill_new.dart';

class HistoryOrderNew extends StatelessWidget {
  const HistoryOrderNew({
    super.key,
    required this.historyOrder,
  });

  final List<String> historyOrder;
  @override
  Widget build(BuildContext context) {
    return SafeArea(
        child: GestureDetector(
      onTap: () {
        FocusScopeNode currentFocus = FocusScope.of(context);

        if (!currentFocus.hasPrimaryFocus) {
          currentFocus.unfocus();
        }
      },
      child: Scaffold(
        backgroundColor: backgroundColor,
        body: Column(
          children: [
            CustomAppBar(
              historyOrder: historyOrder,
            ),
            const SizedBox(
              height: 16,
            ),
            BlocBuilder<SearchHistory, List<String>>(
              builder: (ctxSearch, historyOrderSearch) {
                List<String> historyOrderAfterSearch;
                if (historyOrderSearch.isNotEmpty &&
                    historyOrderSearch[0] == 'start') {
                  historyOrderAfterSearch = historyOrder;
                } else {
                  historyOrderAfterSearch = historyOrderSearch;
                }
                return Expanded(
                  child: ListView.builder(
                    itemCount: historyOrderAfterSearch.length,
                    itemBuilder: (ctxHistory, i) {
                      var jsonDecodeHistory = jsonDecode(
                          historyOrderAfterSearch[
                              historyOrderAfterSearch.length - (i + 1)]);
                      return GestureDetector(
                        onTap: () {
                          Navigator.push(
                            context,
                            MaterialPageRoute(
                              builder: (_) => ViewBillNew(
                                isHistory: true,
                                sessionId: jsonDecodeHistory['session'],
                                branchCodeH: jsonDecodeHistory['branch_code'],
                                brandCodeH: jsonDecodeHistory['brand'],
                                token: jsonDecodeHistory['token'],
                                userName: jsonDecodeHistory['user_name'],
                              ),
                            ),
                          );
                        },
                        child: Container(
                          margin: const EdgeInsets.only(
                            bottom: 8,
                            left: paddingLeftRight,
                            right: paddingLeftRight,
                          ),
                          decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(6),
                            color: backgroundWhite,
                          ),
                          height: 72,
                          child: Container(
                            padding: const EdgeInsets.only(
                              left: 16,
                              right: 12,
                              bottom: 16,
                              top: 5,
                            ),
                            child: Row(
                              children: [
                                Expanded(
                                  child: Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    mainAxisAlignment: MainAxisAlignment.center,
                                    children: [
                                      defaultText(
                                        context,
                                        jsonDecodeHistory['user_name'],
                                        style: historyOrderStyle(),
                                      ),
                                      const SizedBox(
                                        height: 4,
                                      ),
                                      defaultText(
                                        context,
                                        "Rp ${formatNumber().format(amountParseToInt(jsonDecodeHistory['total_order']))}",
                                        style: historyOrderStyle(),
                                      )
                                    ],
                                  ),
                                ),
                                Container(
                                  width: 145,
                                  child: Column(
                                    crossAxisAlignment: CrossAxisAlignment.end,
                                    mainAxisAlignment:
                                        MainAxisAlignment.spaceBetween,
                                    children: [
                                      defaultText(
                                        context,
                                        (jsonDecodeHistory['date_order'] ==
                                                null)
                                            ? ''
                                            : jsonDecodeHistory['date_order'],
                                        style: historyOrderStyle(
                                          color: textGreyDeskripsi,
                                        ),
                                      ),
                                      const SizedBox(
                                        height: 15,
                                      ),
                                      fontAwesomeNew(
                                        arrowNext,
                                        16,
                                      )
                                    ],
                                  ),
                                )
                              ],
                            ),
                          ),
                        ),
                      );
                    },
                  ),
                );
              },
            )
          ],
        ),
      ),
    ));
  }
}
