// ignore_for_file: sized_box_for_whitespace, use_build_context_synchronously, avoid_unnecessary_containers

import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../api/api.dart';
import '../../bloc/order_bloc.dart';
import '../../helper/helper.dart';
import '../../helper/widget/poni_bottom_sheet.dart';
import '../../helper/widget/style.dart';
import '../../models/order_variants.dart';
import '../../models/orders.dart';

GestureDetector noteMenu(
  BuildContext context,
  String note,
  int initialValue,
  String callFrom, {
  List<Orders>? list,
  String? id,
  String? namaMenu,
  int? hargaFix,
  String? imageUrl,
}) {
  var initialNote = note;
  final noteController = TextEditingController(text: initialNote);
  List<OrderVariant> orderVariants = [];

  double widthScreen = responsiveWidthScreen(context);
  double currentScreen = MediaQuery.of(context).size.width;
  double maxWidthScreen = getMaxWidthScreen(context, useResponsive);
  double leftRigthPadding =
      (currentScreen > maxWidthScreen) ? (currentScreen - widthScreen) / 2 : 0;

  return GestureDetector(
    onTap: () {
      showModalBottomSheet(
        backgroundColor: Colors.white.withOpacity(0),
        isScrollControlled: true,
        context: context,
        builder: (context) {
          return Container(
            padding: EdgeInsets.symmetric(horizontal: leftRigthPadding),
            child: Container(
                height: MediaQuery.of(context).size.height * 0.9,
                width: (widthScreen > maxWidthScreen)
                    ? maxWidthScreen
                    : widthScreen,
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.only(
                      topRight: Radius.circular(roundedImage),
                      topLeft: Radius.circular(roundedImage)),
                  color: backgroundColor,
                ),
                padding: EdgeInsets.all(widthScreen * 0.05),
                child: Column(
                  children: [
                    Container(
                      height: MediaQuery.of(context).size.height * 0.05,
                      // color: Colors.red,
                      child: Column(
                        children: [
                          Container(
                            height: MediaQuery.of(context).size.height * 0.02,
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: const [PoniBottomSheet()],
                            ),
                          ),
                        ],
                      ),
                    ),
                    Align(
                        alignment: Alignment.centerLeft,
                        child: defaultText(
                          context,
                          "Tambahkan catatan untuk pesanan ini",
                          style: textStyleNormalFont(context),
                        )),
                    const SizedBox(height: 10),
                    TextField(
                      maxLength: maxLengthTextField,
                      maxLines: 5,
                      autofocus: true,
                      keyboardType: TextInputType.text,
                      controller: noteController,
                      style: textStyleNormalFont(context),
                      decoration: InputDecoration(
                        border: InputBorder.none,
                        hintText: placeHolderNote,
                        hintStyle: TextStyle(
                          color: Colors.grey,
                          fontSize:
                              MediaQuery.of(context).size.height * normalFont,
                        ),
                      ),
                    ),
                    SizedBox(
                      height: MediaQuery.of(context).size.height * 0.015,
                    ),
                    Container(
                      // margin: const EdgeInsets.only(right: 10),
                      // color: Colors.red,
                      child: Align(
                        alignment: Alignment.centerRight,
                        child: ElevatedButton(
                            style: ElevatedButton.styleFrom(
                                backgroundColor: buttonColor),
                            onPressed: () async {
                              // list[index].note = noteController.text;
                              if (callFrom == fromMenu) {
                                context.read<OrdersBloc>().insertData([
                                  [
                                    id,
                                    namaMenu,
                                    initialValue,
                                    hargaFix,
                                    list,
                                    imageUrl,
                                    orderVariants,
                                    hargaFix,
                                    noteController.text
                                  ]
                                ], context);
                              } else if (callFrom == fromBill) {
                                await Api.changeOrderDetail(
                                  context,
                                  id!,
                                  initialValue,
                                  noteController.text,
                                );
                              }
                              Navigator.pop(context);
                            },
                            child: defaultText(context, "Simpan")),
                      ),
                    )
                  ],
                )),
          );
        },
      );
    },
    child: fontAwesome(
      context,
      pencil,
      pencilSize,
      color: buttonColor,
      isBold: false,
    ),
  );
}
