// ignore_for_file: must_be_immutable, sized_box_for_whitespace

import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:flutter_easyloading/flutter_easyloading.dart';

import '../../bloc/check_voucher.dart';
import '../../bloc/voucher_list.dart';
import '../../helper/helper.dart';
import '../../helper/widget/style.dart';
import '../../models/voucher_list.dart';
import 'payment.dart';
import 'shimmer_voucher_list.dart';

class ListVoucher extends StatelessWidget {
  ListVoucher({
    Key? key,
    required this.widget,
    required this.widthScreen,
    required this.listVoucher,
  }) : super(key: key);

  final Payment widget;
  final double widthScreen;
  List<dynamic> listVoucher;

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<VoucherListBloc, List<VoucherList>>(
      builder: (contextVoucherList, voucherListData) {
        if (voucherListData.isNotEmpty && voucherListData[0].id == '0') {
          return ShimmerVoucherList(widthScreen: widthScreen);
        } else if (voucherListData.isNotEmpty && voucherListData[0].id != '0') {
          return Container(
            height: MediaQuery.of(context).size.height * 0.54,
            width: widthScreen * 0.895,

            padding: EdgeInsets.only(
              top: MediaQuery.of(context).size.height * 0.01,
              bottom: MediaQuery.of(context).size.height * 0.03,
            ),
            // color: Colors.red,
            child: ListView.builder(
                itemCount: voucherListData.length,
                itemBuilder: (contextVoucher, i) {
                  String minTransaction;
                  int valueMinTransaction;
                  if (voucherListData[i].minTransaction >
                      voucherListData[i].value) {
                    valueMinTransaction = voucherListData[i].minTransaction;
                    minTransaction =
                        "Min Transaksi ${formatNumber().format(valueMinTransaction)}";
                    minTransaction =
                        " ${formatNumber().format(valueMinTransaction)}";
                  } else {
                    valueMinTransaction = voucherListData[i].value;
                    minTransaction =
                        "Min Transaksi ${formatNumber().format(valueMinTransaction)}";
                  }
                  bool isCanSelect = true;
                  if (widget.outstandingAll <
                          voucherListData[i].minTransaction ||
                      widget.outstandingAll < voucherListData[i].value) {
                    isCanSelect = false;
                  }
                  return GestureDetector(
                    onTap: () {
                      if (isCanSelect) {
                        if (listVoucher.isNotEmpty &&
                            listVoucher[0] != '0' &&
                            listVoucher[2] ==
                                voucherListData[i].verificationNumber) {
                          context.read<VoucherCheck>().changeVoucher();
                        } else {
                          context
                              .read<VoucherCheck>()
                              .check(voucherListData[i].verificationNumber);
                        }
                      } else {
                        EasyLoading.showToast(
                            "Tambah minimal ${formatNumber().format(valueMinTransaction - widget.outstandingAll)} untuk menggunakan voucher");
                      }
                    },
                    child: Container(
                      width: double.infinity,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(roundedButton),
                        color: (listVoucher.isNotEmpty &&
                                listVoucher[0] != '0' &&
                                listVoucher[2] ==
                                    voucherListData[i].verificationNumber)
                            ? selectedColor
                            : backGroundPayment,
                      ),
                      padding: EdgeInsets.symmetric(
                        horizontal: widthScreen * 0.02,
                        vertical: MediaQuery.of(context).size.height * 0.01,
                      ),
                      margin: EdgeInsets.only(
                          bottom: MediaQuery.of(context).size.height * 0.01),
                      child: Column(
                        children: [
                          Container(
                            width: double.infinity,
                            height: MediaQuery.of(context).size.height * 0.12,
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.only(
                                topLeft: Radius.circular(roundedButton),
                                topRight: Radius.circular(roundedButton),
                              ),
                              image: DecorationImage(
                                  colorFilter: (!isCanSelect)
                                      ? const ColorFilter.mode(
                                          Colors.grey,
                                          BlendMode.saturation,
                                        )
                                      : null,
                                  fit: BoxFit.fill,
                                  image: NetworkImage(
                                    voucherListData[i].titleImageUrl,
                                  )),
                            ),
                            // child: ClipRRect(
                            //   borderRadius: BorderRadius.only(
                            //     topLeft: Radius.circular(roundedButton),
                            //     topRight: Radius.circular(roundedButton),
                            //   ),
                            //   child: Image(
                            //     fit: BoxFit.fill,
                            //     image: NetworkImage(
                            //       voucherListData[i].titleImageUrl,
                            //     ),
                            //   ),
                            // ),
                          ),
                          Container(
                            margin: EdgeInsets.only(
                              top: MediaQuery.of(context).size.height * 0.01,
                              bottom: MediaQuery.of(context).size.height * 0.01,
                            ),
                            child: Row(
                              children: [
                                Container(
                                  width: widthScreen * 0.5,
                                  // color: Colors.red,
                                  child: Column(
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      defaultText(
                                        context,
                                        voucherListData[i].rewardTitle,
                                        style: textStyleTitleReward(context,
                                            textColor: (listVoucher
                                                        .isNotEmpty &&
                                                    listVoucher[0] != '0' &&
                                                    listVoucher[2] ==
                                                        voucherListData[i]
                                                            .verificationNumber)
                                                ? textInButton
                                                : null,
                                            isBold: true),
                                      ),
                                      defaultText(
                                        context,
                                        voucherListData[i].rewardSubTitle,
                                        style: textStyleTitleReward(
                                          context,
                                          textColor: (listVoucher.isNotEmpty &&
                                                  listVoucher[0] != '0' &&
                                                  listVoucher[2] ==
                                                      voucherListData[i]
                                                          .verificationNumber)
                                              ? textInButton
                                              : null,
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                                SizedBox(
                                  width: widthScreen * 0.01,
                                ),
                                Container(
                                  width: widthScreen * 0.34,
                                  // color: Colors.black,
                                  child: Column(
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    crossAxisAlignment: CrossAxisAlignment.end,
                                    children: [
                                      defaultText(
                                        context,
                                        'Berakhir Pada',
                                        textAlign: TextAlign.end,
                                        style: textStyleTitleReward(
                                          context,
                                          textColor: (listVoucher.isNotEmpty &&
                                                  listVoucher[0] != '0' &&
                                                  listVoucher[2] ==
                                                      voucherListData[i]
                                                          .verificationNumber)
                                              ? textInButton
                                              : Colors.black,
                                        ),
                                      ),
                                      defaultText(
                                        context,
                                        formatDate(
                                          voucherListData[i].expired,
                                          toLocal: true,
                                        ),
                                        textAlign: TextAlign.end,
                                        style: textStyleTitleReward(
                                          context,
                                          textColor: (listVoucher.isNotEmpty &&
                                                  listVoucher[0] != '0' &&
                                                  listVoucher[2] ==
                                                      voucherListData[i]
                                                          .verificationNumber)
                                              ? textInButton
                                              : null,
                                        ),
                                      ),
                                      SizedBox(
                                        height:
                                            MediaQuery.of(context).size.height *
                                                0.005,
                                      ),
                                      // (!isCanSelect)
                                      //     ? defaultText(
                                      //         context,
                                      //         minTransaction,
                                      //         textAlign: TextAlign.end,
                                      //         style: textStyleVoucherMinTrans(
                                      //           context,
                                      //           textColor: (listVoucher
                                      //                       .isNotEmpty &&
                                      //                   listVoucher[0] != '0' &&
                                      //                   listVoucher[2] ==
                                      //                       voucherListData[i]
                                      //                           .verificationNumber)
                                      //               ? textInButton
                                      //               : Colors.black45,
                                      //         ),
                                      //       )
                                      //     : const SizedBox()
                                    ],
                                  ),
                                )
                              ],
                            ),
                          ),
                          (!isCanSelect)
                              ? Divider(
                                  height: MediaQuery.of(context).size.height *
                                      0.005,
                                )
                              : const SizedBox(),
                          (!isCanSelect)
                              ? Container(
                                  padding: EdgeInsets.symmetric(
                                      vertical:
                                          MediaQuery.of(context).size.height *
                                              0.003),
                                  child: Row(
                                    mainAxisAlignment: MainAxisAlignment.center,
                                    children: [
                                      fontAwesome(
                                        context,
                                        infoCircle,
                                        infoCircleSize,
                                        color: Colors.grey,
                                      ),
                                      SizedBox(
                                        width: widthScreen * 0.01,
                                      ),
                                      defaultText(
                                        context,
                                        'Tambah minimal ${formatNumber().format(valueMinTransaction - widget.outstandingAll)} untuk menggunakan voucher',
                                        style: textStyleVoucherListAddMore(
                                            context),
                                      ),
                                    ],
                                  ),
                                )
                              : const SizedBox()
                        ],
                      ),
                    ),
                  );
                }),
          );
        } else {
          return Container(
            margin: EdgeInsets.only(
              top: MediaQuery.of(context).size.height * 0.03,
              bottom: MediaQuery.of(context).size.height * 0.03,
            ),
            child: Center(
              child: defaultText(context, 'Anda tidak memiliki voucher'),
            ),
          );
        }
      },
    );
  }
}
