import 'package:flutter/cupertino.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../api/api.dart';
import '../helper/helper.dart';
import 'filter_menu.dart';

class BranchExist extends Cubit<String> {
  BranchExist() : super(responseApiWaiting);

  Future<String> getBranch(String branchCode, String brandCode, String role,
      String cashierName, String sessionId) async {
    var apiGetBranch = await Api.getBranch(
        branchCode, brandCode, role, cashierName, sessionId);
    return apiGetBranch;
  }

  void branchExist(BuildContext context, String branchCode, String brandCode,
      String role, String cashierName, String sessionId,
      {bool getMenu = false, String token = ''}) {
    getBranch(branchCode, brandCode, role, cashierName, sessionId)
        .then((value) {
      if (getMenu) {
        context.read<FilterMenuBloc>().catAndMenu(
              branchCode,
              brandCode,
              role,
              cashierName,
              token,
            );
      }
      emit(value);
    });
  }
}
