import 'package:byod/bloc/order_bloc.dart';
import 'package:byod/models/order_details.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../models/order_variants.dart';
import '../models/orders.dart';

class OrderDetailVariant extends Cubit<OrderDetail> {
  OrderDetailVariant()
      : super(OrderDetail(
            allIdVariant: '',
            totalItem: 0,
            totalHarga: 0,
            note: '',
            orderVariant: []));

  void orderDetail(
      String allIdVariant,
      int totalItem,
      int totalHarga,
      String note,
      List<OrderVariant> orderVariant,
      BuildContext context,
      Orders orders,
      List<Orders> listCurrentOrder) {
    OrderDetail orderDetailNow = OrderDetail(
      allIdVariant: allIdVariant,
      totalItem: totalItem,
      totalHarga: totalHarga,
      note: note,
      orderVariant: orderVariant,
    );
    context.read<OrdersBloc>().insertData([
      ['editVariant', orders, listCurrentOrder, orderDetailNow]
    ]);
    emit(orderDetailNow);
  }
}
