import 'package:byod/helper/helper.dart';
import 'package:flutter/material.dart';

import 'style.dart';

class ButtonComponent extends StatelessWidget {
  const ButtonComponent({
    Key? key,
    required this.buttonColor,
    required this.teksButton,
    this.teksButtonColor = textInButton,
    this.height = 43,
    this.width = double.infinity,
    this.fontTeksSize = 14,
  }) : super(key: key);

  final Color buttonColor;
  final String teksButton;
  final Color teksButtonColor;
  final double height;
  final double width;
  final double fontTeksSize;

  @override
  Widget build(BuildContext context) {
    return Container(
      width: width,
      height: height,
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(roundedButtonComponent),
        color: buttonColor,
      ),
      child: Center(
        child: defaultText(
          context,
          teksButton,
          style: addButton(
            font: fontTeksSize,
            color: teksButtonColor,
          ),
        ),
      ),
    );
  }
}
