// ignore_for_file: must_be_immutable

import 'package:byod/models/orders.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../bloc/order_bloc.dart';
import '../../helper/helper.dart';

class MenuFavorite extends StatefulWidget {
  String id;
  int hargaFix;
  int hargaCoret;
  String namaMenu;
  MenuFavorite(
      {Key? key,
      required this.id,
      required this.hargaFix,
      required this.hargaCoret,
      required this.namaMenu})
      : super(key: key);

  @override
  State<MenuFavorite> createState() => _MenuFavoriteState();
}

class _MenuFavoriteState extends State<MenuFavorite> {
  int initialValue = 0;

  @override
  Widget build(BuildContext context) {
    return Container(
      // alignment: Alignment.center,
      padding: const EdgeInsets.only(top: 5),
      decoration: BoxDecoration(
          // color: Colors.red,
          borderRadius: BorderRadius.circular(15)),
      child: BlocBuilder<OrdersBloc, List<Orders>>(
        builder: (context, list) {
          return Column(
            children: [
              Container(
                height: MediaQuery.of(context).size.height * 0.25,
                decoration: BoxDecoration(
                    // color: Colors.red,
                    borderRadius: BorderRadius.circular(15)),
                child: ClipRRect(
                  borderRadius: BorderRadius.circular(15),
                  child: const Image(
                    fit: BoxFit.fill,
                    image: NetworkImage(
                        'https://www.siftandsimmer.com/wp-content/uploads/2021/03/matcha-espresso-fusion1.jpg'),
                  ),
                ),
              ),
              Container(
                height: MediaQuery.of(context).size.height * 0.075,
                width: double.infinity,
                margin: EdgeInsets.only(
                    top: MediaQuery.of(context).size.height * 0.01,
                    bottom: MediaQuery.of(context).size.width * 0.01),
                // color: Colors.green,
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(
                      widget.namaMenu,
                      maxLines: 2,
                      overflow: TextOverflow.ellipsis,
                      style: const TextStyle(
                          fontWeight: FontWeight.w500, fontSize: 20),
                    ),
                    const SizedBox(height: 10),
                    Row(
                      children: [
                        Text(
                          formatNumber().format(widget.hargaFix),
                          overflow: TextOverflow.clip,
                          style: const TextStyle(
                              fontWeight: FontWeight.w500, fontSize: 15),
                        ),
                        const SizedBox(width: 5),
                        Text(
                          formatNumber().format(widget.hargaCoret),
                          overflow: TextOverflow.clip,
                          style: const TextStyle(
                              fontWeight: FontWeight.w400,
                              fontSize: 15,
                              color: Colors.black45,
                              decoration: TextDecoration.lineThrough),
                        ),
                      ],
                    ),
                  ],
                ),
              ),
              GestureDetector(
                onTap: () {
                  if (initialValue == 0) {
                    initialValue += 1;
                    context.read<OrdersBloc>().insertData([
                      [widget.id, widget.namaMenu, 1, widget.hargaFix, list]
                    ]);
                    setState(() {});
                  }
                },
                child: Container(
                    height: MediaQuery.of(context).size.height * 0.04,
                    width: MediaQuery.of(context).size.width * 0.3,
                    decoration: BoxDecoration(
                        color: (initialValue == 0) ? buttonColor : null,
                        borderRadius: BorderRadius.circular(20)),
                    child: AnimatedSwitcher(
                      duration: Duration(milliseconds: animatedTime),
                      transitionBuilder: (child, animation) =>
                          ScaleTransition(scale: animation, child: child),
                      child: (initialValue > 0)
                          ? Row(
                              key: const Key('1'),
                              mainAxisAlignment: MainAxisAlignment.spaceAround,
                              children: [
                                GestureDetector(
                                  onTap: () {
                                    if (initialValue > 0) {
                                      initialValue -= 1;
                                      context.read<OrdersBloc>().insertData(
                                        [
                                          [
                                            widget.id,
                                            widget.namaMenu,
                                            -1,
                                            widget.hargaFix,
                                            list
                                          ]
                                        ],
                                      );
                                      setState(() {});
                                    }
                                  },
                                  child: Icon(
                                    Icons.remove_circle_outline_rounded,
                                    color: buttonColor,
                                  ),
                                ),
                                // const SizedBox(width: 10),
                                Text(
                                  initialValue.toString(),
                                  style: const TextStyle(
                                      fontSize: 20,
                                      fontWeight: FontWeight.w400,
                                      color: Colors.black54),
                                ),
                                // const SizedBox(width: 10),
                                GestureDetector(
                                  onTap: () {
                                    initialValue += 1;
                                    context.read<OrdersBloc>().insertData(
                                      [
                                        [
                                          widget.id,
                                          widget.namaMenu,
                                          1,
                                          widget.hargaFix,
                                          list
                                        ]
                                      ],
                                    );
                                    setState(() {});
                                  },
                                  child: Icon(
                                    Icons.add_circle_outline_rounded,
                                    color: buttonColor,
                                  ),
                                ),
                              ],
                            )
                          : const Center(
                              key: Key('2'),
                              child: Text(
                                "Add",
                                style: TextStyle(
                                    fontWeight: FontWeight.w600,
                                    color: textInButton),
                              )),
                    )),
              )
            ],
          );
        },
      ),
    );
  }
}
