// ignore_for_file: sized_box_for_whitespace

import 'dart:math';

import 'package:byod/helper/widget/button_modal.dart';
import 'package:byod/ui/payment/function.dart';
import 'package:flutter/material.dart';

import '../../helper/helper.dart';
import '../../helper/widget/style.dart';
import '../../main.dart';
import '../screen_responsive.dart';
import '../viewbill/view_bill_new.dart';

class PaymentBalance extends StatelessWidget {
  const PaymentBalance({
    super.key,
    required this.balanceMember,
    required this.outStanding,
    required this.orderId,
  });

  final int balanceMember;
  final int outStanding;
  final String orderId;
  @override
  Widget build(BuildContext context) {
    double currentScreen = MediaQuery.of(context).size.width;
    return SafeArea(
      child: Scaffold(
        backgroundColor: backgroundColor,
        body: ScreenResponsive(
          widget: CorePaymentBalance(
            outStanding: outStanding,
            balanceMember: balanceMember,
            orderId: orderId,
          ),
          isCoreLayout: true,
          widthScreen: currentScreen,
        ),
      ),
    );
  }
}

class CorePaymentBalance extends StatelessWidget {
  const CorePaymentBalance({
    super.key,
    required this.balanceMember,
    required this.outStanding,
    required this.orderId,
  });
  final int balanceMember;
  final int outStanding;
  final String orderId;

  @override
  Widget build(BuildContext context) {
    int outStandingTopayMember = min(outStanding, balanceMember);
    double widthScreen = responsiveWidthScreen(context);
    String branchCode = prefs.getString("outlet") ?? '';
    String brandCode = prefs.getString("brand") ?? '';
    String customerName = prefs.getString("userName") ?? '';
    return Container(
      width: widthScreen,
      child: Stack(
        children: [
          Column(
            children: [
              const CustomAppBarBalance(),
              const SizedBox(
                height: 24,
              ),
              Container(
                width: widthScreen,
                color: backgroundWhite,
                padding: const EdgeInsets.only(
                  left: paddingLeftRight,
                  right: paddingLeftRight,
                  top: 16,
                ),
                child: Container(
                  padding:
                      const EdgeInsets.symmetric(horizontal: 16, vertical: 20),
                  decoration: BoxDecoration(
                    color: greyBalancePayment,
                    borderRadius: BorderRadius.circular(13),
                  ),
                  child: Column(
                    mainAxisSize: MainAxisSize.min,
                    children: [
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          defaultText(context, 'Total Tagihan',
                              style: rincianPembayaran(
                                font: 14,
                              )),
                          defaultText(
                            context,
                            "Rp ${formatNumber().format(outStanding)}",
                            style: rincianPembayaran(
                              font: 14,
                            ),
                          )
                        ],
                      ),
                      const SizedBox(
                        height: 10,
                      ),
                      const Divider(
                        thickness: 1,
                        color: dividerGrey2,
                      ),
                      const SizedBox(
                        height: 10,
                      ),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          defaultText(
                            context,
                            'Excelso Balance',
                            style: rincianPembayaran(
                              font: 14,
                            ),
                          ),
                          defaultText(context,
                              "Rp ${formatNumber().format(balanceMember)}",
                              style: rincianPembayaran(
                                font: 14,
                              ))
                        ],
                      ),
                      const SizedBox(
                        height: 10,
                      ),
                      const Divider(
                        thickness: 1,
                        color: dividerGrey2,
                      ),
                      const SizedBox(
                        height: 10,
                      ),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          defaultText(
                            context,
                            'Nilai Bayar',
                            style: rincianPembayaran(
                              font: 14,
                            ),
                          ),
                          defaultText(
                            context,
                            "Rp ${formatNumber().format(outStandingTopayMember)}",
                            style: rincianPembayaran(
                              font: 14,
                            ),
                          )
                        ],
                      ),
                    ],
                  ),
                ),
              ),
              Expanded(
                child: Container(
                  width: widthScreen,
                  color: backgroundWhite,
                ),
              )
            ],
          ),
          Positioned(
            bottom: 0,
            child: Container(
              width: widthScreen,
              height: 83,
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(16),
                color: backgroundWhite,
                boxShadow: const [
                  BoxShadow(
                    color: Colors.grey,
                    blurRadius: 5.0,
                  )
                ],
              ),
              padding: const EdgeInsets.all(20),
              child: GestureDetector(
                onTap: () {
                  addPaymentBalance(context, orderId, branchCode, brandCode,
                      customerName, outStandingTopayMember);
                },
                child: ButtonComponent(
                  buttonColor: buttonColor,
                  teksButton: 'Bayar',
                ),
              ),
            ),
          )
        ],
      ),
    );
  }
}

class CustomAppBarBalance extends StatelessWidget {
  const CustomAppBarBalance({
    Key? key,
  }) : super(key: key);
  @override
  Widget build(BuildContext context) {
    return Container(
      padding: const EdgeInsets.only(
        top: 15,
        bottom: 22,
        left: paddingLeftRight,
        right: paddingLeftRight,
      ),
      // padding: const EdgeInsets.symmetric(horizontal: paddingLeftRight),
      color: backgroundWhite,
      child: Column(
        children: [
          Row(
            // mainAxisAlignment: MainAxisAlignment.start,
            children: [
              GestureDetector(
                onTap: () {
                  Navigator.pushReplacement(
                    context,
                    MaterialPageRoute(builder: (_) => const ViewBillNew()),
                  );
                },
                child: Container(
                  width: 24,
                  height: 24,
                  child: Center(
                    child: fontAwesomeNew(
                      arrowBack,
                      arrowBackSize,
                    ),
                  ),
                ),
              ),
              const SizedBox(
                width: 16,
              ),
              Center(
                child: defaultText(
                  context,
                  'Excelso Member',
                  maxLines: 1,
                  overFlow: TextOverflow.ellipsis,
                  style: appBarNameViewBill(),
                ),
              ),
            ],
          ),
        ],
      ),
    );
  }
}
