// ignore_for_file: sized_box_for_whitespace

import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../bloc/branch_exist.dart';
import '../../bloc/filter_menu.dart';
import '../../helper/helper.dart';
import '../../helper/widget/style.dart';
import '../../main.dart';
import '../home/new_home2.dart';

class CustomAppBar extends StatelessWidget {
  const CustomAppBar({
    Key? key,
    required this.isHistory,
  }) : super(key: key);

  final bool isHistory;

  @override
  Widget build(BuildContext context) {
    String branchCode = prefs.getString('outlet') ?? '';
    String brandCode = prefs.getString('brand') ?? '';
    String role = prefs.getString('role') ?? '';
    String cashierName = prefs.getString('cashier_name') ?? '';
    String sessionId = prefs.getString('sessionId') ?? '';
    String tokenMember = prefs.getString('token') ?? '';
    return Container(
      padding: const EdgeInsets.only(
        top: 15,
        bottom: 19,
        left: paddingLeftRight,
        right: paddingLeftRight,
      ),
      // padding: const EdgeInsets.symmetric(horizontal: paddingLeftRight),
      color: backgroundWhite,
      child: Row(
        // mainAxisAlignment: MainAxisAlignment.start,
        children: [
          GestureDetector(
            onTap: () {
              if (!isHistory) {
                Navigator.pushReplacement(
                  context,
                  MaterialPageRoute(
                    builder: (_) => const NewHome2(),
                  ),
                );
                context.read<BranchExist>().branchExist(
                      context,
                      branchCode,
                      brandCode,
                      role,
                      cashierName,
                      sessionId,
                      getMenu: true,
                      token: tokenMember,
                    );
              } else {
                Navigator.pop(context);
              }
            },
            child: Container(
              width: 35,
              height: 24,
              color: backgroundWhite,
              child: Center(
                child: fontAwesomeNew(
                  arrowBack,
                  arrowBackSize,
                ),
              ),
            ),
          ),
          const SizedBox(
            width: 5,
          ),
          Center(
            child: defaultText(
              context,
              (!isHistory) ? 'Check-Out' : 'Riwayat Pesanan',
              maxLines: 1,
              overFlow: TextOverflow.ellipsis,
              style: appBarNameViewBill(),
            ),
          ),
        ],
      ),
    );
  }
}
