// ignore_for_file: sized_box_for_whitespace

import 'package:flutter/material.dart';
import '../../models/bill_detail.dart';
import 'order_view_bill_new.dart';

class ListOrder extends StatelessWidget {
  const ListOrder({
    Key? key,
    required this.billDetail,
    required this.isHistory,
    required this.tableStatus,
  }) : super(key: key);

  final List<BillDetail> billDetail;
  final bool isHistory;
  final int tableStatus;

  @override
  Widget build(BuildContext context) {
    int itemCounts = billDetail.length;
    return ListView.builder(
      physics: const NeverScrollableScrollPhysics(), // to disable  scrolling
      shrinkWrap: true,
      itemCount: itemCounts,
      itemBuilder: (ctx, i) {
        return OrderViewBillNew(
          billDetail: billDetail[i],
          lastItem: (i + 1 == itemCounts) ? true : false,
          isHistory: isHistory,
          tableStatus: tableStatus,
        );
      },
    );
  }
}
