import 'package:byod/helper/helper.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../models/rate_value_selected.dart';

class FeedbackSelect extends Cubit<RateValueSelected> {
  FeedbackSelect()
      : super(
          RateValueSelected(
              ratingFeedback: noRate, answerOption: [], message: ''),
        );

  void select(
    RateValueSelected currentValue,
    int rating,
    String answerOption,
    String message,
  ) {
    Map<String, dynamic> json;
    if (currentValue.ratingFeedback == rating) {
      List<String> selectedAnswer = currentValue.answerOption;
      if (selectedAnswer.contains(answerOption)) {
        selectedAnswer.remove(answerOption);
      } else {
        selectedAnswer.remove('');
        selectedAnswer.add(answerOption);
      }
      json = {
        "rating": rating,
        "answer_option": selectedAnswer,
        "message": message
      };
    } else {
      json = {
        "rating": rating,
        "answer_option": [answerOption],
        "message": message
      };
    }

    RateValueSelected result = RateValueSelected.feedBackSelect(json);
    emit(result);
  }
}
