import 'package:byod/models/bill.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../api/api.dart';
import '../helper/helper.dart';
import '../main.dart';

class ViewBillBloc extends Cubit<List<Bill>> {
  ViewBillBloc()
      : super([
          Bill(
            id: defaultViewBill,
            totalSeluruhOrderan: '',
            subTotalSeluruhOrderan: '',
            totalPerCustomer: 0,
            customerName: '',
            tableStatus: 0,
            orderStatus: 0,
            outStandingPay: '',
            outStandingIndividu: '',
            invoice: '',
            totalService: '',
            totalServiceTax: '',
            discountTotal: '',
            tableName: '',
            isFeedBack: false,
            dokuMinPay: "0",
            dateOrder: '',
          )
        ]);
  void getBill({
    String sessionIdH = '',
    String branchCodeH = '',
    String brandCodeH = '',
    String tableNumberH = '',
    String tokenH = '',
    String userNameH = '',
  }) async {
    String branchCode;
    String brandCode;
    String tableNumber;
    String token;
    if (sessionIdH != '') {
      // for history view
      branchCode = branchCodeH;
      brandCode = brandCodeH;
      tableNumber = tableNumberH;
      token = tokenH;
    } else {
      branchCode = prefs.getString("outlet") ?? '';
      brandCode = prefs.getString("brand") ?? '';
      tableNumber = prefs.getString("table_number") ?? '';
      token = prefs.getString("token") ?? '';
    }
    List<Bill> bill;
    if (sessionIdH == '') {
      bill = await Api.getBill(
        branchCode,
        brandCode,
        tableNumber,
        token,
      );
    } else {
      bill = await Api.getBill(
        branchCode,
        brandCode,
        tableNumber,
        token,
        sessionIdH: sessionIdH,
        userNameH: userNameH,
      );
    }

    emit(bill);
  }

  void backToDefault() {
    List<Bill> defaultBill = [
      Bill(
        id: defaultViewBill,
        totalSeluruhOrderan: '',
        subTotalSeluruhOrderan: '',
        totalPerCustomer: 0,
        customerName: '',
        tableStatus: 0,
        orderStatus: 0,
        outStandingPay: '',
        outStandingIndividu: '',
        invoice: '',
        totalService: '',
        totalServiceTax: '',
        discountTotal: '',
        tableName: '',
        isFeedBack: false,
        dokuMinPay: "0",
        dateOrder: '',
      )
    ];
    emit(defaultBill);
  }
}
