import 'package:byod/models/voucher_list.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../api/api.dart';

class VoucherListBloc extends Cubit<List<VoucherList>> {
  VoucherListBloc()
      : super([
          VoucherList(
              id: '0',
              expired: '',
              isUsed: 0,
              verificationNumber: '',
              rewardTitle: '',
              rewardSubTitle: '',
              titleImageUrl: '',
              contentImageUrl: '',
              value: 0,
              minTransaction: 0)
        ]);

  Future<List<VoucherList>> voucherApi() async {
    return await Api.getVoucherList();
  }

  void getVoucherList() {
    voucherApi().then((value) {
      emit(value);
    });
  }
}
