import 'package:byod/models/payment_list.dart';

import 'bill_detail.dart';

class Bill {
  String id;
  String totalSeluruhOrderan;
  String subTotalSeluruhOrderan;
  int totalPerCustomer;
  String customerName;
  int tableStatus;
  int orderStatus;
  String outStandingPay;
  String outStandingIndividu;
  String dateOrder;
  List<BillDetail> billDetail;
  List<PaymentList> paymentList;
  String invoice;
  String totalService;
  String totalServiceTax;
  String discountTotal;
  String tableName;
  bool isFeedBack;
  String dokuMinPay;
  // List<MemberInfo> memberInfo;

  Bill(
      {required this.id,
      required this.totalSeluruhOrderan,
      required this.subTotalSeluruhOrderan,
      required this.totalPerCustomer,
      required this.customerName,
      required this.tableStatus,
      required this.orderStatus,
      required this.outStandingPay,
      required this.outStandingIndividu,
      required this.dateOrder,
      this.billDetail = const [],
      this.paymentList = const [],
      required this.invoice,
      required this.totalService,
      required this.totalServiceTax,
      required this.discountTotal,
      required this.tableName,
      required this.isFeedBack,
      required this.dokuMinPay
      // this.memberInfo = const []
      });

  factory Bill.createBill(Map<String, dynamic> json) {
    return Bill(
      id: json['id'],
      totalSeluruhOrderan: json['total'],
      subTotalSeluruhOrderan: json['subtotal'],
      totalPerCustomer: json['total_per_customer'],
      customerName: json['customer_name'],
      tableStatus: json['table_status'],
      orderStatus: json['order_status'],
      billDetail: json['order_detail'],
      paymentList: json['payment_list'],
      outStandingPay: json['outstanding'],
      invoice: json['invoice'],
      totalService: json['total_service'],
      totalServiceTax: json['total_service_tax'],
      outStandingIndividu: json['my_self_outstanding'],
      discountTotal: json['discount_total'],
      tableName: json['table_number'],
      isFeedBack: json['is_feedback'],
      dokuMinPay: json['doku_minimum_payment'],
      dateOrder: json['order_date'],
      // memberInfo: json['member_info']
    );
  }
}
