class BillDetail {
  String id;
  String customerName;
  String menuName;
  int quantity;
  String price;
  String subTotal;
  String total;
  String service;
  String serviceTax;
  int orderStatus;
  String notes;
  // int paidStatus;
  List<String> variant;

  BillDetail(
      {required this.id,
      required this.customerName,
      required this.menuName,
      required this.quantity,
      required this.price,
      required this.subTotal,
      required this.total,
      required this.service,
      required this.serviceTax,
      required this.orderStatus,
      required this.notes,
      // required this.paidStatus,
      this.variant = const []});

  factory BillDetail.createBillDetail(Map<String, dynamic> json) {
    return BillDetail(
        id: json['id'],
        customerName: json['customer_name'],
        menuName: json['name'],
        quantity: json['quantity'],
        price: json['price'],
        subTotal: json['subtotal'],
        total: json['total'],
        service: json['service'],
        serviceTax: json['service_tax'],
        orderStatus: json['order_status'],
        notes: json['notes'],
        // paidStatus: json['paid_status'],
        variant: json['variant']);
  }
}
