import 'package:byod/models/order_variants.dart';

class OrderDetail {
  late String allIdVariant; // untuk identifikasi order
  late int totalItem;
  late int totalHarga;
  late String note = '';
  late List<OrderVariant> orderVariant;

  OrderDetail(
      {required this.allIdVariant,
      required this.totalItem,
      required this.totalHarga,
      required this.note,
      required this.orderVariant});

  factory OrderDetail.createOrderDetail(Map<String, dynamic> json) {
    return OrderDetail(
        allIdVariant: json['all_id_variant'],
        totalItem: json['total_item'],
        totalHarga: json['total_harga'],
        note: json['note'],
        orderVariant: json['variants']);
  }
}
