import 'package:byod/models/order_details.dart';

class Orders {
  final String id;
  late int totalItem;
  final String namaMenu;
  final int satuanHarga;
  final String imageUrl;
  late List<OrderDetail> orderDetail;
  late int totalHarga;
  late String note;

  Orders(
      {required this.id,
      required this.totalItem,
      required this.namaMenu,
      required this.satuanHarga,
      required this.imageUrl,
      this.orderDetail = const [],
      this.totalHarga = 0,
      this.note = ''});

  factory Orders.createOrders(Map<String, dynamic> json) {
    return Orders(
        id: json['id'],
        totalItem: json['totalItem'],
        namaMenu: json['namaMenu'].toString(),
        satuanHarga: json['satuanHarga'],
        imageUrl: json['image_url'],
        orderDetail: json['order_detail'],
        totalHarga: json['totalHarga'],
        note: json['note']);
  }
}
