// ignore_for_file: sized_box_for_whitespace

import 'dart:convert';

import 'package:byod/helper/helper.dart';
import 'package:byod/ui/screen_responsive.dart';
import 'package:flutter/material.dart';
import '../../helper/widget/style.dart';
import '../viewbill/view_bill.dart';

class HistoryOrder extends StatelessWidget {
  final List<String> historyOrder;
  const HistoryOrder({Key? key, required this.historyOrder}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    double widthScreen = responsiveWidthScreen(context);
    double currentScreen = MediaQuery.of(context).size.width;
    double maxWidthScreen = getMaxWidthScreen(context, useResponsive);
    double paddingLeftRight = widthScreen * 0.05;
    // double marginLeftRight = widthScreen * 0.01;
    return SafeArea(
      child: Scaffold(
        backgroundColor: backgroundColor,
        body: ScreenResponsive(
          widget: coreHistory(
              context, widthScreen, maxWidthScreen, paddingLeftRight),
          widthScreen: currentScreen,
          isCoreLayout: true,
        ),
      ),
    );
  }

  Center coreHistory(BuildContext context, double widthScreen,
      double maxWidthScreen, double paddingLeftRight) {
    return Center(
      child: Container(
        width: (widthScreen > maxWidthScreen) ? maxWidthScreen : widthScreen,
        padding: EdgeInsets.symmetric(
          horizontal: paddingLeftRight,
        ),
        // child: Column(
        //   children: [
        //     customAppbar(
        //       context,
        //       widthScreen,
        //       maxWidthScreen,
        //     ),
        //     historyListOrder(context, widthScreen, maxWidthScreen)
        //   ],
        // ),
        child: Stack(
          children: [
            Column(
              children: [
                customAppbar(
                  context,
                  widthScreen,
                  maxWidthScreen,
                ),
                historyListOrder(context, widthScreen, maxWidthScreen)
              ],
            ),
            Positioned(
              bottom: MediaQuery.of(context).size.height * positionedBottom,
              child: Column(
                children: [
                  GestureDetector(
                    onTap: () {
                      Navigator.pushReplacement(context,
                          MaterialPageRoute(builder: (_) => ViewBill()));
                    },
                    child: buttonBottom(
                      context,
                      'Kembali',
                      buttonColor,
                      0.9,
                      colorText: textInButton,
                    ),
                  )
                ],
              ),
            )
          ],
        ),
      ),
    );
  }

  Container historyListOrder(
      BuildContext context, double widthScreen, double maxWidthScreen) {
    return Container(
      height: MediaQuery.of(context).size.height * 0.82,
      width: (widthScreen > maxWidthScreen) ? maxWidthScreen : widthScreen,
      // color: Colors.red,
      child: ListView.builder(
        itemCount: historyOrder.length,
        itemBuilder: (context, i) {
          var jsonDecodeHistory =
              jsonDecode(historyOrder[historyOrder.length - (i + 1)]);
          return GestureDetector(
            onTap: () {
              Navigator.push(
                  context,
                  MaterialPageRoute(
                      builder: (_) => ViewBill(
                            isHistory: true,
                            sessionId: jsonDecodeHistory['session'],
                            branchCode: jsonDecodeHistory['branch_code'],
                            brandCode: jsonDecodeHistory['brand'],
                            token: jsonDecodeHistory['token'],
                            userName: jsonDecodeHistory['user_name'],
                          )));
            },
            child: Container(
              margin: EdgeInsets.only(
                bottom: MediaQuery.of(context).size.height * 0.01,
              ),
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(roundedDetailPayment),
                color: backGroundPayment,
              ),
              padding: EdgeInsets.symmetric(
                vertical: MediaQuery.of(context).size.height * 0.02,
              ),
              child: Row(
                children: [
                  Container(
                    width: widthScreen * 0.5,
                    padding: EdgeInsets.symmetric(
                      horizontal: widthScreen * 0.03,
                    ),
                    // color: Colors.green,
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        defaultText(
                          context,
                          jsonDecodeHistory['user_name'],
                          style: textStyleListHistoryOrder(
                            context,
                            isBold: true,
                          ),
                        ),
                        SizedBox(
                          height: MediaQuery.of(context).size.height * 0.005,
                        ),
                        defaultText(
                          context,
                          "Rp ${formatNumber().format(amountParseToInt(jsonDecodeHistory['total_order']))}",
                          style: textStyleListHistoryOrder(
                            context,
                            isBold: false,
                            font: listOrderFontOther,
                          ),
                        ),
                      ],
                    ),
                  ),
                  Container(
                    width: widthScreen * 0.4,
                    padding: EdgeInsets.symmetric(
                      horizontal: widthScreen * 0.03,
                    ),
                    // color: Colors.blue,
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.end,
                      children: [
                        defaultText(
                          context,
                          "Tanggal Order",
                          style: textStyleListHistoryOrder(
                            context,
                            isBold: false,
                            font: listOrderFontOther,
                          ),
                        ),
                        SizedBox(
                          height: MediaQuery.of(context).size.height * 0.005,
                        ),
                        defaultText(
                          context,
                          (jsonDecodeHistory['date_order'] == null)
                              ? ''
                              : localDate(
                                  jsonDecodeHistory['date_order'],
                                  isHistory: true,
                                ),
                          style: textStyleListHistoryOrder(
                            context,
                            isBold: false,
                            font: listOrderFontOther,
                          ),
                        )
                      ],
                    ),
                  )
                ],
              ),
            ),
          );
        },
      ),
    );
  }

  Container customAppbar(
    BuildContext context,
    double widthScreen,
    double maxWidthScreen,
  ) {
    return Container(
      height: MediaQuery.of(context).size.height * 0.08,
      width: (widthScreen > maxWidthScreen) ? maxWidthScreen : widthScreen,
      // color: Colors.amber,
      child: Row(
        // mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: [
          GestureDetector(
            onTap: () {
              Navigator.pushReplacement(
                context,
                MaterialPageRoute(
                  builder: (_) => ViewBill(),
                ),
              );
            },
            child: Container(
              // color: Colors.black,
              height: double.infinity,
              width: widthScreen * 0.2,
              // child: const Icon(Icons.arrow_back_ios_new_rounded),
              child: Align(
                alignment: Alignment.center,
                child: fontAwesome(
                  context,
                  backIcon,
                  backIconSize,
                ),
              ),
            ),
          ),
          Container(
            // color: Colors.red,
            height: double.infinity,
            width: widthScreen * 0.58,
            child: Align(
                alignment: Alignment.centerLeft,
                // child: Text(
                //   'Pesanan Meja $tableNumber',
                //   overflow: TextOverflow.ellipsis,
                //   maxLines: 1,
                //   // style: const TextStyle(
                //   //     fontSize: 20, fontWeight: FontWeight.w600),
                //   style: textStyleMenuList(context),
                // )
                child: defaultText(
                  context,
                  'Riwayat Transaksi',
                  overFlow: TextOverflow.ellipsis,
                  maxLines: 1,
                  style: textStyleMenuList(context),
                )),
          ),
        ],
      ),
    );
  }
}
