// ignore_for_file: sized_box_for_whitespace, must_be_immutable

import 'package:byod/bloc/order_bloc.dart';
import 'package:byod/helper/widget/poni_bottom_sheet.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../bloc/order_variant_temporary.dart';
import '../../helper/helper.dart';
import '../../helper/widget/style.dart';
import '../../models/order_details.dart';
import '../../models/order_variants.dart';
import '../../models/orders.dart';
import '../../models/variant_categories.dart';
import 'bottom_sheet_variant.dart';
import 'variant_cat.dart';

class ShowMenuModal extends StatefulWidget {
  String imageUrl;
  String namaMenu;
  int hargaMenu;
  bool isHavevariant;
  String description;
  String id;
  List<VariantCategories> variantCat;
  bool isSell;
  ShowMenuModal(
      {Key? key,
      required this.imageUrl,
      required this.namaMenu,
      required this.hargaMenu,
      required this.isHavevariant,
      required this.description,
      required this.id,
      this.variantCat = const [],
      required this.isSell})
      : super(key: key);

  @override
  State<ShowMenuModal> createState() => _ShowMenuModalState();
}

class _ShowMenuModalState extends State<ShowMenuModal> {
  List<OrderVariant> orderVariants = [];
  @override
  Widget build(BuildContext context) {
    double widthScreen = responsiveWidthScreen(context);
    double currentScreen = MediaQuery.of(context).size.width;
    double maxWidthScreen = getMaxWidthScreen(context, useResponsive);
    double leftRigthPadding = (currentScreen > maxWidthScreen)
        ? (currentScreen - widthScreen) / 2
        : 0;
    return BlocBuilder<OrdersBloc, List<Orders>>(
      builder: (context, list) {
        int indexListOrderan =
            list.indexWhere((listOrderan) => listOrderan.id == widget.id);
        int initialValue;
        if (indexListOrderan != -1) {
          initialValue = list[indexListOrderan].totalItem;
        } else {
          initialValue = 0;
        }
        return Container(
          padding: EdgeInsets.symmetric(horizontal: leftRigthPadding),
          child: Container(
            height: 704,
            child: Container(
              margin: const EdgeInsets.symmetric(
                horizontal: 16,
              ),
              child: Column(
                children: [
                  const SizedBox(
                    height: 8,
                  ),
                  const PoniBottomSheet(),
                  const SizedBox(
                    height: 32,
                  ),
                  Align(
                    alignment: Alignment.topLeft,
                    child: textMenuNameBottomShetModalMenu(
                      context,
                      widget.namaMenu,
                    ),
                  ),
                  const SizedBox(
                    height: 30,
                  ),
                  ClipRRect(
                    borderRadius: BorderRadius.circular(21),
                    child: (widget.imageUrl != '')
                        ? Image(
                            width: 343,
                            height: 350,
                            fit: BoxFit.fill,
                            image: NetworkImage(widget.imageUrl),
                          )
                        : const Image(
                            width: 343,
                            height: 350,
                            fit: BoxFit.fill,
                            image: AssetImage('assets/noimage.png')),
                  ),
                  const SizedBox(
                    height: 20,
                  ),
                  (widget.description != '')
                      ? Align(
                          alignment: Alignment.topLeft,
                          child: defaultText(
                            context,
                            'Deskripsi',
                            style: textDeskripsiHeader(),
                          ),
                        )
                      : const SizedBox(),
                  const SizedBox(
                    height: 12,
                  ),
                  (widget.description != '')
                      ? Align(
                          alignment: Alignment.topLeft,
                          child: defaultText(
                            context,
                            widget.description,
                            maxLines: 5,
                            overFlow: TextOverflow.ellipsis,
                            style: textDeskripsi(),
                          ),
                        )
                      : const SizedBox(),
                  const SizedBox(
                    height: 31,
                  ),
                  const Spacer(),
                  Container(
                    padding: const EdgeInsets.only(bottom: 18),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        defaultText(
                          context,
                          'Rp ${formatNumber().format(widget.hargaMenu)}',
                          style: amountMenuStyle(
                              font: 20, fontWeight: FontWeight.w500),
                        ),
                        GestureDetector(
                          onTap: () {
                            if (widget.isSell) {
                              if (widget.isHavevariant) {
                                if (indexListOrderan == -1) {
                                  Navigator.pop(context);
                                  context
                                      .read<OrderVariantTemporaryBloc>()
                                      .insertDataVariant(
                                          widget.id,
                                          widget.hargaMenu,
                                          1,
                                          []); // check pada bloc untuk mengethui list arraynya
                                  Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                          builder: (_) => VariantCat(
                                                namaMenu: widget.namaMenu,
                                                variantCategories:
                                                    widget.variantCat,
                                                initPrice: widget.hargaMenu,
                                                idItem: widget.id,
                                                imageUrl: widget.imageUrl,
                                                listCurrentOrder: list,
                                                orderDetail: OrderDetail(
                                                    allIdVariant: '',
                                                    totalItem: 0,
                                                    totalHarga: 0,
                                                    note: '',
                                                    orderVariant: []),
                                              )));
                                } else {
                                  Navigator.pop(context);
                                  showModalBottomSheet(
                                    backgroundColor:
                                        Colors.white.withOpacity(0),
                                    isScrollControlled: true,
                                    context: context,
                                    builder: (context) {
                                      return CustomizeVariant(
                                          orders: list[indexListOrderan],
                                          variantCat: widget.variantCat);
                                    },
                                  );
                                }
                              } else {
                                initialValue += 1;
                                context.read<OrdersBloc>().insertData([
                                  [
                                    widget.id,
                                    widget.namaMenu,
                                    initialValue,
                                    widget.hargaMenu,
                                    list,
                                    widget.imageUrl,
                                    orderVariants,
                                    widget.hargaMenu,
                                    (indexListOrderan != -1)
                                        ? list[indexListOrderan].note
                                        : '',
                                  ]
                                ], context);
                                Navigator.pop(context);
                              }
                            }
                          },
                          child: Container(
                            height: 38,
                            width: 119,
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.circular(6),
                              color: buttonColor,
                            ),
                            child: Center(
                              child: defaultText(
                                context,
                                'Tambah',
                                style: addButtonMenu(),
                              ),
                            ),
                          ),
                        )
                      ],
                    ),
                  )
                  // GestureDetector(
                  //   onTap: () {
                  //     if (widget.isSell) {
                  //       if (widget.isHavevariant) {
                  //         if (indexListOrderan == -1) {
                  //           Navigator.pop(context);
                  //           context
                  //               .read<OrderVariantTemporaryBloc>()
                  //               .insertDataVariant(
                  //                   widget.id,
                  //                   widget.hargaMenu,
                  //                   1,
                  //                   []); // check pada bloc untuk mengethui list arraynya
                  //           Navigator.push(
                  //               context,
                  //               MaterialPageRoute(
                  //                   builder: (_) => VariantCat(
                  //                         namaMenu: widget.namaMenu,
                  //                         variantCategories: widget.variantCat,
                  //                         initPrice: widget.hargaMenu,
                  //                         idItem: widget.id,
                  //                         imageUrl: widget.imageUrl,
                  //                         listCurrentOrder: list,
                  //                         orderDetail: OrderDetail(
                  //                             allIdVariant: '',
                  //                             totalItem: 0,
                  //                             totalHarga: 0,
                  //                             note: '',
                  //                             orderVariant: []),
                  //                       )));
                  //         } else {
                  //           Navigator.pop(context);
                  //           showModalBottomSheet(
                  //             backgroundColor: Colors.white.withOpacity(0),
                  //             isScrollControlled: true,
                  //             context: context,
                  //             builder: (context) {
                  //               return CustomizeVariant(
                  //                   orders: list[indexListOrderan],
                  //                   variantCat: widget.variantCat);
                  //             },
                  //           );
                  //         }
                  //       } else {
                  //         initialValue += 1;
                  //         context.read<OrdersBloc>().insertData([
                  //           [
                  //             widget.id,
                  //             widget.namaMenu,
                  //             initialValue,
                  //             widget.hargaMenu,
                  //             list,
                  //             widget.imageUrl,
                  //             orderVariants,
                  //             widget.hargaMenu,
                  //             (indexListOrderan != -1)
                  //                 ? list[indexListOrderan].note
                  //                 : '',
                  //           ]
                  //         ], context);
                  //         Navigator.pop(context);
                  //       }
                  //     }
                  //   },
                  //   child: buttonBottom(
                  //     context,
                  //     (widget.isSell) ? "Tambahkan Orderan" : "Habis",
                  //     (widget.isSell) ? buttonColor : disabledColor,
                  //     double.infinity,
                  //   ),
                  // )
                ],
              ),
            ),
          ),
        );
      },
    );
  }
}
