// ignore_for_file: sized_box_for_whitespace

import 'package:byod/bloc/order_bloc.dart';
import 'package:byod/helper/helper.dart';
import 'package:byod/helper/widget/poni_bottom_sheet.dart';
import 'package:byod/helper/widget/style.dart';
import 'package:byod/models/order_details.dart';
import 'package:byod/ui/home/variant_cat.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import '../../bloc/order_detail_variant.dart';
import '../../bloc/order_variant_temporary.dart';
import '../../models/orders.dart';
import '../../models/variant_categories.dart';

// ignore: must_be_immutable
class CustomizeVariant extends StatefulWidget {
  Orders orders;
  List<VariantCategories> variantCat;
  CustomizeVariant({
    Key? key,
    required this.orders,
    required this.variantCat,
  }) : super(key: key);

  @override
  State<CustomizeVariant> createState() => _CustomizeVariantState();
}

class _CustomizeVariantState extends State<CustomizeVariant> {
  @override
  Widget build(BuildContext context) {
    double widthScreen = responsiveWidthScreen(context);
    double currentScreen = MediaQuery.of(context).size.width;
    double maxWidthScreen = getMaxWidthScreen(context, useResponsive);
    double leftRigthPadding = (currentScreen > maxWidthScreen)
        ? (currentScreen - widthScreen) / 2
        : 0;
    // print(widget.orders.totalHarga);

    return Container(
      padding: EdgeInsets.symmetric(horizontal: leftRigthPadding),
      child: Container(
        height: MediaQuery.of(context).size.height * 0.85,
        decoration: const BoxDecoration(
            borderRadius: BorderRadius.only(
                topRight: Radius.circular(30), topLeft: Radius.circular(30)),
            color: backgroundColor),
        child: BlocBuilder<OrdersBloc, List<Orders>>(
          builder: (context, listCurrentOrder) {
            int indexOrders = listCurrentOrder
                .indexWhere((element) => element == widget.orders);
            if (indexOrders == -1) {
              Navigator.pop(context);
            }
            return Stack(
              children: [
                Column(
                  children: [
                    SizedBox(
                      height: MediaQuery.of(context).size.height * 0.1,
                      // color: Colors.red,
                      child: Column(
                        children: [
                          SizedBox(
                            height: MediaQuery.of(context).size.height * 0.01,
                          ),
                          SizedBox(
                            height: MediaQuery.of(context).size.height * 0.01,
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: const [
                                PoniBottomSheet(),
                              ],
                            ),
                          ),
                          Container(
                              margin: EdgeInsets.only(
                                top: MediaQuery.of(context).size.height * 0.02,
                                // left: MediaQuery.of(context).size.width * 0.02,
                                // right: MediaQuery.of(context).size.width * 0.02
                              ),
                              // padding: const EdgeInsets.only(top: 10),
                              padding: EdgeInsets.only(
                                  left: widthScreen * 0.05,
                                  right: widthScreen * 0.05),
                              height: MediaQuery.of(context).size.height * 0.06,
                              width: double.infinity,
                              child: defaultText(
                                context,
                                widget.orders.namaMenu,
                                maxLines: 1,
                                overFlow: TextOverflow.ellipsis,
                                style: textStyleMenuList(context),
                              ))
                        ],
                      ),
                    ),
                    Container(
                      height: MediaQuery.of(context).size.height * 0.65,
                      // color: Colors.red,
                      child: ListView.builder(
                          itemCount: widget.orders.orderDetail.length,
                          itemBuilder: (context, i) {
                            int totalHarga =
                                widget.orders.orderDetail[i].totalHarga.toInt();
                            int totalItem =
                                widget.orders.orderDetail[i].totalItem.toInt();
                            int satuanHarga = totalHarga ~/ totalItem;
                            double heightDefault =
                                MediaQuery.of(context).size.height *
                                    0.025 *
                                    widget.orders.orderDetail[i].orderVariant
                                        .length;
                            return Container(
                              margin: const EdgeInsets.only(bottom: 5),
                              height:
                                  MediaQuery.of(context).size.height * 0.05 +
                                      heightDefault,
                              // color: Colors.red,
                              child: Column(
                                children: [
                                  Container(
                                    // height: MediaQuery.of(context).size.height *
                                    //     0.025,
                                    height: heightDefault,
                                    // color: Colors.amber,
                                    child: Row(
                                      children: [
                                        Container(
                                          padding: EdgeInsets.only(
                                              left: widthScreen * 0.05,
                                              right: widthScreen * 0.05),
                                          width: widthScreen * 0.7,
                                          // color: Colors.blue,
                                          child: ListView.builder(
                                              itemCount: widget
                                                  .orders
                                                  .orderDetail[i]
                                                  .orderVariant
                                                  .length,
                                              itemBuilder: (context, k) {
                                                return defaultText(
                                                    context,
                                                    widget.orders.orderDetail[i]
                                                        .orderVariant[k].name,
                                                    style: textStyleNormalFont(
                                                      context,
                                                      font: variantModalFont,
                                                    ));
                                              }),
                                        ),
                                        Container(
                                          padding: EdgeInsets.only(
                                              left: widthScreen * 0.05,
                                              right: widthScreen * 0.05),
                                          width: widthScreen * 0.3,
                                          height: double.infinity,
                                          // color: Colors.green,
                                          child: Align(
                                              alignment: Alignment.topRight,
                                              child: defaultText(
                                                context,
                                                formatNumber().format(widget
                                                    .orders
                                                    .orderDetail[i]
                                                    .totalHarga),
                                                style:
                                                    textStyleMenuList(context),
                                              )),
                                        )
                                      ],
                                    ),
                                  ),
                                  Container(
                                    height: MediaQuery.of(context).size.height *
                                        0.05,
                                    padding: EdgeInsets.only(
                                        left: widthScreen * 0.05,
                                        right: widthScreen * 0.05),
                                    child: Row(
                                      mainAxisAlignment: MainAxisAlignment.end,
                                      crossAxisAlignment:
                                          CrossAxisAlignment.center,
                                      children: [
                                        GestureDetector(
                                          onTap: () {
                                            widget.orders.orderDetail[i]
                                                    .totalItem -
                                                1;
                                            widget.orders.orderDetail[i]
                                                    .totalHarga -
                                                satuanHarga;
                                            context
                                                .read<OrderDetailVariant>()
                                                .orderDetail(
                                                    widget.orders.orderDetail[i]
                                                        .allIdVariant,
                                                    widget.orders.orderDetail[i]
                                                            .totalItem -
                                                        1,
                                                    widget.orders.orderDetail[i]
                                                            .totalHarga -
                                                        satuanHarga,
                                                    widget.orders.orderDetail[i]
                                                        .note,
                                                    widget.orders.orderDetail[i]
                                                        .orderVariant,
                                                    context,
                                                    widget.orders,
                                                    listCurrentOrder);
                                            setState(() {});
                                          },
                                          child: Container(
                                            width: widthScreen * 0.07,
                                            color: backgroundColor,
                                            child: Align(
                                              alignment: Alignment.center,
                                              child: fontAwesome(
                                                context,
                                                minusCircle,
                                                minusCircleSize,
                                                color: buttonColor,
                                              ),
                                            ),
                                          ),
                                        ),
                                        SizedBox(width: widthScreen * 0.02),
                                        defaultText(
                                          context,
                                          widget.orders.orderDetail[i].totalItem
                                              .toString(),
                                          style: textStyleNormalFont(
                                            context,
                                          ),
                                        ),
                                        SizedBox(width: widthScreen * 0.02),
                                        GestureDetector(
                                          onTap: () {
                                            context
                                                .read<OrderDetailVariant>()
                                                .orderDetail(
                                                    widget.orders.orderDetail[i]
                                                        .allIdVariant,
                                                    widget.orders.orderDetail[i]
                                                            .totalItem +
                                                        1,
                                                    widget.orders.orderDetail[i]
                                                            .totalHarga +
                                                        satuanHarga,
                                                    widget.orders.orderDetail[i]
                                                        .note,
                                                    widget.orders.orderDetail[i]
                                                        .orderVariant,
                                                    context,
                                                    widget.orders,
                                                    listCurrentOrder);
                                            widget.orders.orderDetail[i]
                                                    .totalItem +
                                                1;
                                            widget.orders.orderDetail[i]
                                                    .totalHarga +
                                                satuanHarga;
                                            setState(() {});
                                          },
                                          child: Container(
                                            width: widthScreen * 0.07,
                                            color: backgroundColor,
                                            child: Align(
                                              alignment: Alignment.center,
                                              child: fontAwesome(
                                                context,
                                                plusCicle,
                                                plusCicleSize,
                                                color: buttonColor,
                                              ),
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                  )
                                ],
                              ),
                            );
                          }),
                    ),
                  ],
                ),
                Positioned(
                  // width: widthScreen, // harus ada widh agar bisa positioned
                  left: widthScreen * 0.04,
                  right: widthScreen * 0.04,
                  bottom: MediaQuery.of(context).size.height * positionedBottom,
                  child: SizedBox(
                    height: MediaQuery.of(context).size.height * 0.1,
                    // color: Colors.blue,
                    child: GestureDetector(
                      onTap: () {
                        Navigator.pop(context);
                        context.read<OrderVariantTemporaryBloc>().insertDataVariant(
                            widget.orders.id,
                            widget.orders.satuanHarga,
                            1,
                            []); // check pada bloc untuk mengethui list arraynya
                        Navigator.push(
                            context,
                            MaterialPageRoute(
                                builder: (_) => VariantCat(
                                    namaMenu: widget.orders.namaMenu,
                                    variantCategories: widget.variantCat,
                                    initPrice: widget.orders.satuanHarga,
                                    idItem: widget.orders.id,
                                    imageUrl: widget.orders.imageUrl,
                                    listCurrentOrder: listCurrentOrder,
                                    orderDetail: OrderDetail(
                                        allIdVariant: '',
                                        totalItem: 0,
                                        totalHarga: 0,
                                        note: '',
                                        orderVariant: []))));
                      },
                      child: buttonBottom(
                        context,
                        "Tambah Variant",
                        buttonColor,
                        0.92,
                      ),
                    ),
                  ),
                )
              ],
            );
          },
        ),
        // color: Colors.amber,
      ),
    );
  }
}
