// ignore_for_file: must_be_immutable

import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../bloc/fav_selected_bar.dart';
import '../../helper/helper.dart';
import '../../helper/widget/style.dart';
import '../../models/fav_group.dart';

class FavoriteList extends StatefulWidget {
  List<FavoriteGroup> favoriteList;
  FavoriteList({Key? key, required this.favoriteList}) : super(key: key);

  @override
  State<FavoriteList> createState() => _FavoriteListState();
}

class _FavoriteListState extends State<FavoriteList> {
  int selectedIndex = 0;

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<FavSelectedBar, Map<String, dynamic>>(
      builder: (contextSelectedBar, selectedBarIndex) {
        selectedIndex = selectedBarIndex['index'];
        return ListView.builder(
          scrollDirection: Axis.horizontal,
          itemCount: widget.favoriteList.length,
          itemBuilder: (context, i) {
            return GestureDetector(
              onTap: () {
                FocusScopeNode currentFocus = FocusScope.of(context);

                if (!currentFocus.hasPrimaryFocus) {
                  currentFocus.unfocus();
                }
                context
                    .read<FavSelectedBar>()
                    .selectedBarFav(i, widget.favoriteList[i].id);
              },
              child: Container(
                color: backgroundColor,
                margin: EdgeInsets.only(
                    left: (i == 0) ? 0 : 12.5,
                    right: (i == widget.favoriteList.length - 1) ? 0 : 12.5),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    defaultText(
                      context,
                      widget.favoriteList[i].name,
                      style: favNameStyle(),
                    ),
                    AnimatedSwitcher(
                      duration: Duration(milliseconds: animatedTime),
                      transitionBuilder:
                          (Widget child, Animation<double> animation) {
                        return ScaleTransition(scale: animation, child: child);
                      },
                      child: (selectedIndex == i)
                          ? Container(
                              key: const Key('underline'),
                              margin: const EdgeInsets.only(top: 2),
                              width: 30,
                              height: 1,
                              color: buttonColor)
                          : const SizedBox(
                              key: Key('underline'),
                            ),
                    )
                  ],
                ),
              ),
            );
          },
        );
      },
    );
  }
}
