// ignore_for_file: sized_box_for_whitespace, must_be_immutable

import 'package:byod/helper/helper.dart';
import 'package:byod/helper/widget/style.dart';
import 'package:byod/models/order_details.dart';
import 'package:byod/ui/home/variant_new.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../bloc/order_variant_value.dart';
import '../../main.dart';
import '../../models/variant_categories.dart';

class VariantCatNew extends StatefulWidget {
  final List<VariantCategories> variantCategories;
  final int initPrice;
  const VariantCatNew({
    Key? key,
    required this.variantCategories,
    required this.initPrice,
  }) : super(key: key);

  @override
  State<VariantCatNew> createState() => _VariantCatNewState();
}

class _VariantCatNewState extends State<VariantCatNew> {
  final noteCatController = TextEditingController();

  OrderDetail orderDetail = OrderDetail(
    allIdVariant: '',
    totalItem: 0,
    totalHarga: 0,
    note: '',
    orderVariant: [],
  );

  @override
  void initState() {
    context
        .read<OrderVariantValueBloc>()
        .setOrderVariant('', '', '', 0, 0, [], '');
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    FocusScopeNode currentFocus = FocusScope.of(context);
    double widthScreen = responsiveWidthScreen(context);
    return SafeArea(
        child: GestureDetector(
      onTap: () {
        if (!currentFocus.hasPrimaryFocus) {
          currentFocus.unfocus();
        }
      },
      child: Scaffold(
        backgroundColor: backgroundColor,
        body: Container(
          padding: const EdgeInsets.symmetric(horizontal: paddingLeftRight),
          child: Column(
            children: [
              Container(
                margin: const EdgeInsets.only(
                  top: 15,
                  bottom: 20,
                ),
                child: Row(
                  children: [
                    GestureDetector(
                      onTap: () {
                        Navigator.pop(context);
                      },
                      child: Container(
                        width: 24,
                        height: 24,
                        child: Center(
                          child: fontAwesomeNew(
                            arrowBack,
                            arrowBackSize,
                          ),
                        ),
                      ),
                    ),
                    const SizedBox(
                      width: 16,
                    ),
                    Center(
                      child: defaultText(
                        context,
                        'Custom Pesanan',
                        style: appBarNameVariant(),
                      ),
                    ),
                  ],
                ),
              ),
              Expanded(
                child: ListView(
                  children: [
                    ListView.builder(
                        physics:
                            const NeverScrollableScrollPhysics(), // to disable GridView's scrolling
                        shrinkWrap: true,
                        itemCount: widget.variantCategories.length,
                        itemBuilder: ((context, index) {
                          return Container(
                            width: double.infinity,
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Container(
                                  margin: EdgeInsets.only(
                                      bottom:
                                          MediaQuery.of(context).size.height *
                                              0.01,
                                      top: MediaQuery.of(context).size.height *
                                          0.01),
                                  child: Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      defaultText(
                                        context,
                                        widget.variantCategories[index].caption,
                                        style: variantStyleText(),
                                      ),
                                      defaultText(
                                        context,
                                        (widget.variantCategories[index].type ==
                                                typeMandatory)
                                            ? 'Pilih Salah Satu'
                                            : (widget.variantCategories[index]
                                                        .type ==
                                                    typeAutoInsert)
                                                ? 'Sudah termasuk'
                                                : 'Optional',
                                        style: variantStyleText(
                                          font: 12,
                                          fontWeight: FontWeight.w300,
                                        ),
                                      )
                                    ],
                                  ),
                                ),
                                const Divider(
                                  thickness: 0.5,
                                  color: textColorBlack,
                                ),
                                VariantNew(
                                  variants:
                                      widget.variantCategories[index].variant,
                                  captioncategories:
                                      widget.variantCategories[index].caption,
                                  type: widget.variantCategories[index].type,
                                  initPrice: widget.initPrice,
                                  idCategory:
                                      widget.variantCategories[index].id,
                                  orderDetail: orderDetail,
                                ),
                              ],
                            ),
                          );
                        })),
                    const SizedBox(
                      height: 74,
                    ),
                    defaultText(
                      context,
                      "Note :",
                      style: variantStyleText(
                        font: 20,
                        fontWeight: FontWeight.w400,
                      ),
                    ),
                    const SizedBox(
                      height: 12,
                    ),
                    // TextField(
                    //   maxLength: maxLengthTextField,
                    //   maxLines: 2,
                    //   autofocus: false,
                    //   keyboardType: TextInputType.text,
                    //   controller: noteCatController,
                    //   style: textStyleNormalFont(context),
                    //   decoration: InputDecoration(
                    //     prefixIcon: Image(
                    //       image: const AssetImage('assets/icons/search.png'),
                    //       color: Colors.grey.withOpacity(0.8),
                    //       height: 20,
                    //       width: 20,
                    //     ),
                    //     hintText: placeHolderNote,
                    //     hintStyle: TextStyle(
                    //       color: Colors.grey,
                    //       fontSize:
                    //           MediaQuery.of(context).size.height * normalFont,
                    //     ),
                    //   ),
                    // ),
                    Container(
                      height: 35,
                      child: TextField(
                        maxLength: maxLengthTextField,
                        autofocus: false,
                        style: const TextStyle(
                          color: textColorBlack,
                          fontFamily: 'OpenSans',
                          fontSize: 10,
                          fontWeight: FontWeight.w400,
                        ),
                        textAlignVertical: TextAlignVertical.center,
                        decoration: InputDecoration(
                          counterText: "",
                          filled: true,
                          enabledBorder: OutlineInputBorder(
                            borderSide: const BorderSide(
                              width: 1,
                              color: textColorPlaceHolder,
                            ),
                            borderRadius: BorderRadius.circular(21),
                          ),
                          focusedBorder: OutlineInputBorder(
                            borderSide: const BorderSide(
                              width: 1,
                              color: textColorPlaceHolder,
                            ),
                            borderRadius: BorderRadius.circular(21),
                          ),
                          prefixIcon: const Image(
                            image: AssetImage('assets/icons/note-grey.png'),
                            color: textColorPlaceHolder,
                            height: 13.33,
                            width: 13.33,
                          ),
                          fillColor: backgroundColor,
                          contentPadding: EdgeInsets.zero,
                          hintText: placeHolderNote,
                          hintStyle: const TextStyle(
                            color: textColorPlaceHolder,
                            fontFamily: 'OpenSans',
                            fontSize: 10,
                            fontWeight: FontWeight.w400,
                          ),
                        ),
                      ),
                    ),
                    SizedBox(
                      height: MediaQuery.of(context).size.height * 0.03,
                    ),
                    (isExcelso)
                        ? (!currentFocus.hasPrimaryFocus)
                            ? SizedBox(
                                height:
                                    MediaQuery.of(context).size.height * 0.5,
                              )
                            : const SizedBox()
                        : const SizedBox()
                  ],
                ),
              )
            ],
          ),
        ),
      ),
    ));
  }
}
