// ignore_for_file: sized_box_for_whitespace

import 'package:byod/bloc/order_variant_temporary.dart';
import 'package:byod/bloc/order_variant_value.dart';
import 'package:byod/helper/widget/style.dart';
import 'package:byod/models/order_details.dart';
import 'package:byod/models/order_variants.dart';
import 'package:byod/models/variants.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../helper/helper.dart';

// ignore: must_be_immutable
class VariantNew extends StatefulWidget {
  List<Variants> variants;
  String captioncategories;
  int type;
  int initPrice;
  String idCategory;
  OrderDetail orderDetail;
  VariantNew(
      {Key? key,
      required this.variants,
      required this.captioncategories,
      required this.type,
      required this.initPrice,
      required this.idCategory,
      required this.orderDetail})
      : super(key: key);

  @override
  State<VariantNew> createState() => _VariantNewState();
}

class _VariantNewState extends State<VariantNew> {
  String variantMenu = '';
  List<dynamic> variantRadio = [];
  List<String> optionalVariant = [];
  @override
  Widget build(BuildContext context) {
    double widthScreen = responsiveWidthScreen(context);
    double currentScreen = MediaQuery.of(context).size.width;

    double maxWidthScreen = getMaxWidthScreen(context, useResponsive);
    // if (variantRadio.isNotEmpty) {
    //   print(variantRadio[0]);
    // }
    FocusScopeNode currentFocus = FocusScope.of(context);
    return BlocBuilder<OrderVariantValueBloc, List<OrderVariant>>(
      builder: (context, orderVariants) {
        return ListView.builder(
            physics:
                const NeverScrollableScrollPhysics(), // to disable GridView's scrolling
            shrinkWrap: true,
            itemCount: widget.variants.length,
            itemBuilder: ((context, i) {
              var priceVariant = amountParseToInt(widget.variants[i].price);

              return BlocBuilder<OrderVariantTemporaryBloc, List<dynamic>>(
                builder: (context, listOrders) {
                  var listOrder = listOrders[0];
                  var itemId = listOrder[0];
                  var satuanPrice = listOrder[1];
                  var initialValue = listOrder[2];
                  return variantList(
                      widthScreen,
                      i,
                      context,
                      priceVariant,
                      itemId,
                      satuanPrice,
                      initialValue,
                      orderVariants,
                      maxWidthScreen,
                      currentFocus);
                  // return variantList(widthScreen, i, context, priceVariant,
                  //     itemId, satuanPrice, initialValue, orderVariants);
                },
              );
            }));
      },
    );
  }

  Container variantList(
    double widthScreen,
    int i,
    BuildContext context,
    int priceVariant,
    itemId,
    satuanPrice,
    initialValue,
    List<OrderVariant> orderVariants,
    double maxWidthScreen,
    FocusScopeNode currentFocus,
  ) {
    return Container(
      width: (widthScreen > maxWidthScreen) ? maxWidthScreen : widthScreen,
      child: Column(
        children: [
          Row(
            children: [
              Container(
                width: 160,
                child: defaultText(
                  context,
                  widget.variants[i].name,
                  maxLines: 2,
                  overFlow: TextOverflow.ellipsis,
                  style: variantStyleText(
                    fontWeight: FontWeight.w300,
                    font: 12,
                  ),
                ),
              ),
              Expanded(
                // width: 170,
                // color: Colors.blue,
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Container(
                        child: defaultText(
                      context,
                      (priceVariant > 0)
                          ? formatNumber().format(priceVariant)
                          : "Free",
                      style: variantStyleText(
                        fontWeight: FontWeight.w300,
                        font: 12,
                      ),
                    )),
                    (widget.type == typeMandatory)
                        ? radioButton(
                            i,
                            itemId,
                            satuanPrice,
                            initialValue,
                            variantRadio,
                            priceVariant,
                            widget.idCategory,
                            orderVariants,
                            currentFocus,
                          )
                        : (widget.type == typeOptional)
                            ? checkBoxButton(
                                i,
                                itemId,
                                satuanPrice,
                                initialValue,
                                variantRadio,
                                priceVariant,
                                widget.idCategory,
                                orderVariants,
                                currentFocus,
                              )
                            : const SizedBox()
                  ],
                ),
              ),
            ],
          )
        ],
      ),
    );
  }

  Checkbox checkBoxButton(
    int i,
    String itemId,
    int satuanHarga,
    int initialValue,
    List<dynamic> variantRadio,
    int priceVariant,
    String idCategory,
    List<OrderVariant> orderVariants,
    FocusScopeNode currentFocus,
  ) {
    return Checkbox(
        activeColor: buttonColor,
        value: (optionalVariant.contains(widget.variants[i].id) == true)
            ? true
            : false,
        onChanged: (value) {
          if (!currentFocus.hasPrimaryFocus) {
            currentFocus.unfocus();
          }
          (value == true)
              ? optionalVariant.add(widget.variants[i].id)
              : optionalVariant.remove(widget.variants[i].id);
          context.read<OrderVariantValueBloc>().setOrderVariant(
              idCategory,
              widget.variants[i].id,
              widget.variants[i].name,
              priceVariant,
              typeOptional,
              orderVariants,
              widget.captioncategories,
              forChecBox: value);
          setState(() {});
        });
  }

  Radio<String> radioButton(
      int i,
      String itemId,
      int satuanHarga,
      int initialValue,
      List<dynamic> variantRadio,
      int priceVariant,
      String idCategory,
      List<OrderVariant> orderVariants,
      FocusScopeNode currentFocus) {
    return Radio(
        value: widget.variants[i].id,
        groupValue: variantMenu,
        hoverColor: buttonColor,
        activeColor: buttonColor,
        onChanged: (newValue) {
          if (!currentFocus.hasPrimaryFocus) {
            currentFocus.unfocus();
          }
          // buat list untuk radio button
          variantMenu = newValue.toString();

          context.read<OrderVariantValueBloc>().setOrderVariant(
                idCategory,
                variantMenu.toString(),
                widget.variants[i].name,
                priceVariant,
                typeMandatory,
                orderVariants,
                widget.captioncategories,
              );
          setState(() {});
        });
  }
}
