// ignore_for_file: must_be_immutable

import 'package:byod/helper/helper.dart';
import 'package:byod/helper/widget/style.dart';
import 'package:flutter/material.dart';

class NoRoute extends StatelessWidget {
  String identification;
  NoRoute({Key? key, required this.identification}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return SafeArea(
        child: Scaffold(
            backgroundColor: backgroundColor,
            body: Center(
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  // const Icon(
                  //   Icons.highlight_remove_outlined,
                  //   size: 80,
                  //   color: Colors.red,
                  // ),
                  fontAwesome(
                    context,
                    timesCircleIcon,
                    timesCircleIconSize,
                    color: dangerColor,
                    isBold: false,
                  ),
                  SizedBox(
                    height: MediaQuery.of(context).size.height * 0.05,
                  ),
                  (identification == 'titleError')
                      ? defaultText(
                          context,
                          "Scan QR Atau Kunjungi Alamat Outlet (Error: title)",
                          textAlign: TextAlign.center,
                          style: textStyleNormalFont(context),
                        )
                      : (identification == 'configError')
                          ? defaultText(
                              context,
                              "Scan QR Atau Kunjungi Alamat Outlet (Error: config)",
                              textAlign: TextAlign.center,
                              style: textStyleNormalFont(context),
                            )
                          : defaultText(
                              context,
                              "Scan QR Atau Kunjungi Alamat Outlet",
                              textAlign: TextAlign.center,
                              style: textStyleNormalFont(context),
                            ),
                ],
              ),
            )));
  }
}
