// ignore_for_file: sized_box_for_whitespace

import 'package:flutter/material.dart';
import 'package:shimmer/shimmer.dart';

import '../../helper/helper.dart';

class ShimmerBill extends StatelessWidget {
  const ShimmerBill({
    Key? key,
    required this.widthScreen,
    required this.maxWidthScreen,
    required this.context,
  }) : super(key: key);

  final double widthScreen;
  final double maxWidthScreen;
  final BuildContext context;

  @override
  Widget build(BuildContext context) {
    double paddingLeftRight = widthScreen * 0.05;
    return Shimmer.fromColors(
      baseColor: baseColorShimmer,
      highlightColor: highlightColorShimmer,
      child: Container(
        padding: EdgeInsets.symmetric(
          horizontal: paddingLeftRight,
          vertical: MediaQuery.of(context).size.height * 0.01,
        ),
        width: (widthScreen > maxWidthScreen) ? maxWidthScreen : widthScreen,
        child: Column(
          children: [
            Container(
              height: MediaQuery.of(context).size.height * 0.05,
              width:
                  (widthScreen > maxWidthScreen) ? maxWidthScreen : widthScreen,
              // color: Colors.amber,
              child: Row(
                // mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                children: [
                  Container(
                    color: Colors.black,
                    height: double.infinity,
                    width: widthScreen * 0.1,
                    // child: const Icon(Icons.arrow_back_ios_new_rounded),
                  ),
                  SizedBox(
                    width: widthScreen * 0.01,
                  ),
                  Container(
                    color: Colors.red,
                    height: double.infinity,
                    width: widthScreen * 0.58,
                  ),
                ],
              ),
            ),
            SizedBox(
              height: MediaQuery.of(context).size.height * 0.03,
            ),
            Container(
              height: MediaQuery.of(context).size.height * 0.03,
              width:
                  (widthScreen > maxWidthScreen) ? maxWidthScreen : widthScreen,
              // color: Colors.green,
              child: Row(
                children: [
                  Container(
                    width: widthScreen * 0.88,
                    color: Colors.red,
                  ),
                ],
              ),
            ),
            SizedBox(
              height: MediaQuery.of(context).size.height * 0.02,
            ),
            Container(
              width:
                  (widthScreen > maxWidthScreen) ? maxWidthScreen : widthScreen,
              child: Divider(
                height: MediaQuery.of(context).size.height * 0.005,
                thickness: MediaQuery.of(context).size.height * 0.005,
                color: buttonColor.withOpacity(0.5),
              ),
            ),
            SizedBox(height: MediaQuery.of(context).size.height * 0.009),
            Container(
              width:
                  (widthScreen > maxWidthScreen) ? maxWidthScreen : widthScreen,
              height: MediaQuery.of(context).size.height * 0.05,
              color: Colors.red,
            ),
            SizedBox(height: MediaQuery.of(context).size.height * 0.009),
            Container(
              width:
                  (widthScreen > maxWidthScreen) ? maxWidthScreen : widthScreen,
              height: MediaQuery.of(context).size.height * 0.05,
              color: Colors.red,
            ),
            SizedBox(height: MediaQuery.of(context).size.height * 0.009),
            Container(
              width:
                  (widthScreen > maxWidthScreen) ? maxWidthScreen : widthScreen,
              height: MediaQuery.of(context).size.height * 0.05,
              color: Colors.red,
            ),
          ],
        ),
      ),
    );
  }
}
