import 'package:byod/models/order_details.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import '../models/orders.dart';

class OrdersBloc extends Cubit<List<Orders>> {
  OrdersBloc() : super([]);

  void insertData(Map<String, dynamic> json) {
    if (json['action'] == 'editVariant') {
      // hanya ketika bottom sheet muncul untuk order yang mempunyai variant
      // Orders singleOrder = list[0][1];
      List<Orders> listOrders = json['list_orders'];
      OrderDetail singleOrderDetail = json['single_order_detail'];

      int indexListOrder = 0;
      int indexListOrderDetail = 0;
      for (int d = 0; d < listOrders.length; d++) {
        for (int z = 0; z < listOrders[d].orderDetail.length; z++) {
          if (listOrders[d].orderDetail[z].allIdVariant ==
              singleOrderDetail.allIdVariant) {
            indexListOrder = d;
            indexListOrderDetail = z;
          }
        }
      }
      listOrders[indexListOrder].orderDetail[indexListOrderDetail].totalItem =
          singleOrderDetail.totalItem;
      listOrders[indexListOrder].orderDetail[indexListOrderDetail].totalHarga =
          singleOrderDetail.totalHarga;
      if (singleOrderDetail.totalItem == 0) {
        listOrders[indexListOrder].orderDetail.removeAt(indexListOrderDetail);
        if (listOrders[indexListOrder].orderDetail.isEmpty) {
          listOrders.removeAt(indexListOrder);
        }
      }

      emit(listOrders);
    } else {
      var listOrderOld = json['old_order']; // orderan lama
      List<Orders> orders = [];
      if (listOrderOld.length != 0) {
        // orders = listOrderOld;

        // harus di looping orderan lama, kalau gak blocnya gak ke update, gatau kenapa ?????
        for (var d = 0; d < listOrderOld.length; d++) {
          List<OrderDetail> orderDetailOld = [];
          for (int y = 0; y < listOrderOld[d].orderDetail.length; y++) {
            var xx = {
              "all_id_variant": listOrderOld[d].orderDetail[y].allIdVariant,
              "total_item": listOrderOld[d].orderDetail[y].totalItem,
              "total_harga": listOrderOld[d].orderDetail[y].totalHarga,
              "note": listOrderOld[d].orderDetail[y].note,
              "variants": listOrderOld[d].orderDetail[y].orderVariant,
            };
            orderDetailOld.add(OrderDetail.createOrderDetail(xx));
          }
          var s = {
            'id': listOrderOld[d].id,
            'namaMenu': listOrderOld[d].namaMenu,
            'totalItem': listOrderOld[d].totalItem,
            'satuanHarga': listOrderOld[d].satuanHarga,
            'image_url': listOrderOld[d].imageUrl,
            'order_detail': orderDetailOld,
            'totalHarga': listOrderOld[d].totalHarga,
            'note': listOrderOld[d].note
          };
          orders.add(Orders.createOrders(s));
        }
      }

      int index = orders.indexWhere((order) => order.id == json['menu_id']);

      if (index == -1) {
        List<OrderDetail> orderDetail = [];
        if (json['order_variant'].length > 0) {
          var strItem = json['initvalue'].toString();
          var intItem = int.parse(strItem);
          String allIdVariant = '';
          for (int ii = 0; ii < json['order_variant'].length; ii++) {
            allIdVariant = allIdVariant + json['order_variant'][ii].id;
          }
          var ss = {
            'all_id_variant': allIdVariant,
            'total_item': intItem,
            'total_harga': json['total_price'],
            'note': json['note'],
            'variants': json['order_variant'],
          };
          orderDetail.add(OrderDetail.createOrderDetail(ss));
        }
        if (json['initvalue'] != 0) {
          var x = {
            'id': json['menu_id'],
            'namaMenu': json['menu_name'],
            'totalItem': json['initvalue'],
            'satuanHarga': json['menu_price'],
            'image_url': json['image_url'],
            'order_detail': orderDetail,
            'totalHarga': json['total_price'],
            'note': json['note'],
          };
          orders.add(Orders.createOrders(x));
        }
      } else {
        int finalTotalItem = 0;
        int finalTotalHarga = 0;
        if (orders[index].orderDetail.isNotEmpty) {
          List<OrderDetail> oldOrderDetail = [];
          // oldOrderDetail = orders[index].orderDetail;

          // harus di looping orderan lama, kalau gak blocnya gak ke update, gatau kenapa ?????
          for (int yx = 0; yx < orders[index].orderDetail.length; yx++) {
            var ty = {
              "all_id_variant": orders[index].orderDetail[yx].allIdVariant,
              "total_item": orders[index].orderDetail[yx].totalItem,
              "total_harga": orders[index].orderDetail[yx].totalHarga,
              "note": orders[index].orderDetail[yx].note,
              "variants": orders[index].orderDetail[yx].orderVariant,
            };
            oldOrderDetail.add(OrderDetail.createOrderDetail(ty));
          }
          // check apakah order detail dengan variant yang sama ada atau tidak
          String allIdVariantCheck = '';
          for (int ii = 0; ii < json['order_variant'].length; ii++) {
            allIdVariantCheck =
                allIdVariantCheck + json['order_variant'][ii].id;
          }
          int indexOrderDetail = oldOrderDetail
              .indexWhere((detail) => detail.allIdVariant == allIdVariantCheck);
          if (indexOrderDetail == -1) {
            // ini jika tidak ada maka tambahkan order detail yang baru
            if (json['order_variant'].length > 0) {
              String allIdVariant = '';
              for (int ii = 0; ii < json['order_variant'].length; ii++) {
                allIdVariant = allIdVariant + json['order_variant'][ii].id;
              }
              var ss = {
                'all_id_variant': allIdVariant,
                'total_item': json['initvalue'],
                'total_harga': json['total_price'],
                'note': json['note'],
                'variants': json['order_variant'],
              };
              oldOrderDetail.add(OrderDetail.createOrderDetail(ss));
            }
            int totalItemOrderDetail = 0;
            int totalHargaOrderDetail = 0;
            for (int ky = 0; ky < oldOrderDetail.length; ky++) {
              totalItemOrderDetail += oldOrderDetail[ky].totalItem;
              totalHargaOrderDetail += oldOrderDetail[ky].totalHarga;
            }
            orders[index].orderDetail = oldOrderDetail;
            finalTotalItem = totalItemOrderDetail;
            finalTotalHarga = totalHargaOrderDetail;
          } else {
            // jika sama, maka hanya tambahkan total item dan total harga
            orders[index].orderDetail[indexOrderDetail].totalItem =
                orders[index].orderDetail[indexOrderDetail].totalItem +
                    int.parse(json['initvalue'].toString());
            finalTotalItem =
                orders[index].orderDetail[indexOrderDetail].totalItem +
                    int.parse(json['initvalue'].toString());

            orders[index].orderDetail[indexOrderDetail].totalHarga =
                orders[index].orderDetail[indexOrderDetail].totalHarga +
                    int.parse(json['total_price'].toString());
            finalTotalHarga =
                orders[index].orderDetail[indexOrderDetail].totalHarga +
                    int.parse(json['total_price'].toString());
          }
        } else {
          var s = json['initvalue'].toString();
          var ss = int.parse(s);
          finalTotalItem = ss;
          finalTotalHarga = int.parse(json['total_price'].toString());
        }
        orders[index].note = json['note']; // note di array ke 8

        orders[index].totalItem = finalTotalItem;
        orders[index].totalHarga = finalTotalHarga;
        if (orders[index].totalItem == 0) {
          orders.removeAt(index);
        }
      }

      emit(orders);

      // for (var i = 0; i < list.length; i++) {
      //   // check apakah ada order dengan ID menu
      //   int index = orders.indexWhere((order) => order.id == list[i][0]);

      //   if (index == -1) {
      //     List<OrderDetail> orderDetail = [];
      //     if (list[i][6].length > 0) {
      //       var strItem = list[i][2].toString();
      //       var intItem = int.parse(strItem);
      //       String allIdVariant = '';
      //       for (int ii = 0; ii < list[i][6].length; ii++) {
      //         allIdVariant = allIdVariant + list[i][6][ii].id;
      //       }
      //       var ss = {
      //         'all_id_variant': allIdVariant,
      //         'total_item': intItem,
      //         'total_harga': list[i][7],
      //         'note': list[i][8],
      //         'variants': list[i][6],
      //       };
      //       orderDetail.add(OrderDetail.createOrderDetail(ss));
      //     }
      //     if (list[i][2] != 0) {
      //       var x = {
      //         'id': list[i][0],
      //         'namaMenu': list[i][1],
      //         'totalItem': list[i][2],
      //         'satuanHarga': list[i][3],
      //         'image_url': list[i][5],
      //         'order_detail': orderDetail,
      //         'totalHarga': list[i][7],
      //         'note': list[i][8],
      //       };
      //       orders.add(Orders.createOrders(x));
      //     }
      //   } else {
      //     int finalTotalItem = 0;
      //     int finalTotalHarga = 0;
      //     if (orders[index].orderDetail.isNotEmpty) {
      //       List<OrderDetail> oldOrderDetail = [];
      //       // oldOrderDetail = orders[index].orderDetail;

      //       // harus di looping orderan lama, kalau gak blocnya gak ke update, gatau kenapa ?????
      //       for (int yx = 0; yx < orders[index].orderDetail.length; yx++) {
      //         var ty = {
      //           "all_id_variant": orders[index].orderDetail[yx].allIdVariant,
      //           "total_item": orders[index].orderDetail[yx].totalItem,
      //           "total_harga": orders[index].orderDetail[yx].totalHarga,
      //           "note": orders[index].orderDetail[yx].note,
      //           "variants": orders[index].orderDetail[yx].orderVariant,
      //         };
      //         oldOrderDetail.add(OrderDetail.createOrderDetail(ty));
      //       }
      //       // check apakah order detail dengan variant yang sama ada atau tidak
      //       String allIdVariantCheck = '';
      //       for (int ii = 0; ii < list[i][6].length; ii++) {
      //         allIdVariantCheck = allIdVariantCheck + list[i][6][ii].id;
      //       }
      //       int indexOrderDetail = oldOrderDetail.indexWhere(
      //           (detail) => detail.allIdVariant == allIdVariantCheck);
      //       if (indexOrderDetail == -1) {
      //         // ini jika tidak ada maka tambahkan order detail yang baru
      //         if (list[i][6].length > 0) {
      //           String allIdVariant = '';
      //           for (int ii = 0; ii < list[i][6].length; ii++) {
      //             allIdVariant = allIdVariant + list[i][6][ii].id;
      //           }
      //           var ss = {
      //             'all_id_variant': allIdVariant,
      //             'total_item': list[i][2],
      //             'total_harga': list[i][7],
      //             'note': list[i][8],
      //             'variants': list[i][6],
      //           };
      //           oldOrderDetail.add(OrderDetail.createOrderDetail(ss));
      //         }
      //         int totalItemOrderDetail = 0;
      //         int totalHargaOrderDetail = 0;
      //         for (int ky = 0; ky < oldOrderDetail.length; ky++) {
      //           totalItemOrderDetail += oldOrderDetail[ky].totalItem;
      //           totalHargaOrderDetail += oldOrderDetail[ky].totalHarga;
      //         }
      //         orders[index].orderDetail = oldOrderDetail;
      //         finalTotalItem = totalItemOrderDetail;
      //         finalTotalHarga = totalHargaOrderDetail;
      //       } else {
      //         // jika sama, maka hanya tambahkan total item dan total harga
      //         orders[index].orderDetail[indexOrderDetail].totalItem =
      //             orders[index].orderDetail[indexOrderDetail].totalItem +
      //                 int.parse(list[i][2].toString());
      //         finalTotalItem =
      //             orders[index].orderDetail[indexOrderDetail].totalItem +
      //                 int.parse(list[i][2].toString());

      //         orders[index].orderDetail[indexOrderDetail].totalHarga =
      //             orders[index].orderDetail[indexOrderDetail].totalHarga +
      //                 int.parse(list[i][7].toString());
      //         finalTotalHarga =
      //             orders[index].orderDetail[indexOrderDetail].totalHarga +
      //                 int.parse(list[i][7].toString());
      //       }
      //     } else {
      //       var s = list[i][2].toString();
      //       var ss = int.parse(s);
      //       finalTotalItem = ss;
      //       finalTotalHarga = int.parse(list[i][7].toString());
      //     }
      //     orders[index].note = list[i][8]; // note di array ke 8

      //     orders[index].totalItem = finalTotalItem;
      //     orders[index].totalHarga = finalTotalHarga;
      //     if (orders[index].totalItem == 0) {
      //       orders.removeAt(index);
      //     }
      //   }
      // }
      // emit(orders);
    }
  }

  void clearOrder() {
    List<Orders> orders = [];
    emit(orders);
  }
}
