import 'package:byod/models/branchs.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class SearchBranch extends Cubit<List<Branch>> {
  SearchBranch()
      : super([
          Branch(
            id: '0',
            branchCode: '',
            name: '',
            image: '',
            logo: '',
            isDineIn: false,
            isDelivery: false,
            isPickup: false,
            distance: 0,
          )
        ]);

  void search(String keyword, List<Branch> allBranch) {
    List<Branch> result = [];
    if (keyword.isNotEmpty) {
      for (var x in allBranch) {
        if (x.name.toLowerCase().contains(keyword.toLowerCase())) {
          result.add(x);
        }
      }
      emit(result);
    } else {
      emit(allBranch);
    }
  }
}
