import 'package:byod/helper/prefs.dart';
import 'package:byod/models/bill.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../api/api.dart';
import '../helper/helper.dart';

class ViewBillBloc extends Cubit<List<Bill>> {
  ViewBillBloc()
      : super([
          Bill(
            id: defaultViewBill,
            totalSeluruhOrderan: '',
            subTotalSeluruhOrderan: '',
            totalPerCustomer: 0,
            customerName: '',
            tableStatus: 0,
            orderStatus: 0,
            state: 0,
            outStandingPay: '',
            outStandingIndividu: '',
            invoice: '',
            totalService: '',
            totalServiceTax: '',
            discountTotal: '',
            tableName: '',
            isFeedBack: false,
            dokuMinPay: "0",
            dateOrder: '',
          )
        ]);
  void getBill({
    String orderIdH = '',
    String branchCodeH = '',
    String brandCodeH = '',
    String tableNumberH = '',
    String tokenH = '',
    String userNameH = '',
  }) async {
    String branchCode;
    String brandCode;
    String tableNumber;
    String token;
    if (orderIdH != '') {
      // for history view
      branchCode = branchCodeH;
      brandCode = brandCodeH;
      tableNumber = tableNumberH;
      token = tokenH;
    } else {
      branchCode = getBranchPref();
      brandCode = getBrand();
      tableNumber = getTabelNumber();
      token = getToken();
    }
    List<Bill> bill;
    if (orderIdH == '') {
      bill = await Api.getBill(
        branchCode,
        brandCode,
        tableNumber,
        token,
      );
    } else {
      bill = await Api.getBill(
        branchCode,
        brandCode,
        tableNumber,
        token,
        orderIdH: orderIdH,
        userNameH: userNameH,
      );
    }

    emit(bill);
  }

  void backToDefault() {
    List<Bill> defaultBill = [
      Bill(
        id: defaultViewBill,
        totalSeluruhOrderan: '',
        subTotalSeluruhOrderan: '',
        totalPerCustomer: 0,
        customerName: '',
        tableStatus: 0,
        orderStatus: 0,
        state: 0,
        outStandingPay: '',
        outStandingIndividu: '',
        invoice: '',
        totalService: '',
        totalServiceTax: '',
        discountTotal: '',
        tableName: '',
        isFeedBack: false,
        dokuMinPay: "0",
        dateOrder: '',
      )
    ];
    emit(defaultBill);
  }
}
