import 'package:byod/helper/helper.dart';

import '../main.dart';

const String _orderId = 'order_id';
const String _secretKey = 'secret_key';
const String _sessionCounter = 'session_counter';
const String _sessionId = 'session_id';
const String _baseUrl = 'baseUrl';
const String _tableNumber = 'table_number';
const String _paymentMethod = 'pM';
const String _customerName = 'userName';
const String _totalOrder = 'total_order';
const String _dateOrder = 'date_order';
const String _branch = 'outlet';
const String _brand = 'brand';
const String _token = 'token';
const String _listHistory = 'list_history';
const String _logo = 'logo';
const String _role = 'role';
const String _cashierName = 'cashier_name';
const String _urlLookUp = 'url';
const String _latitude = 'lat';
const String _longitude = 'long';
const String _titleWeb = 'title';
const String _isDeliveryPickup = 'is_delivery_pickup';
const String _typeUrl = 'urlType';
const String _listTypeUrl = 'urlTypeList';
const String _orderType = 'orderType';
const String _isDelivery = 'isDelivery';
const String _isPickup = 'isPickup';
const String _isCustomerDelivery = 'isCustomerDelivery';
const String _mqMessage = 'mqmsg';
const String _tableMode = 'tbm';
const String _branchName = 'bN';
const String _orderCreated = 'oC';
const String _latOutlet = 'latO';
const String _longOutlet = 'longO';
const String _openTime = 'oT';
const String _closeTime = 'cT';
const String _pickupTime = 'puT';

String getBaseUrl() {
  return prefs.getString(_baseUrl) ?? '';
}

Future<void> setBaseUrl(String value) async {
  prefs.setString(_baseUrl, value);
}

String getOrderId() {
  return prefs.getString(_orderId) ?? '';
}

Future<void> setOrderId(String value) async {
  prefs.setString(_orderId, value);
}

String getSecretKey() {
  return prefs.getString(_secretKey) ?? '';
}

Future<void> setSecretKey(String value) async {
  prefs.setString(_secretKey, value);
}

int getSessionCounter() {
  return prefs.getInt(_sessionCounter) ?? 0;
}

Future<void> setSessionCounter(int value) async {
  prefs.setInt(_sessionCounter, value);
}

Future<void> setSessionCounterPlus(int value) async {
  prefs.setInt(_sessionCounter, value + 1);
}

String getSessionId() {
  return prefs.getString(_sessionId) ?? '';
}

Future<void> setSesssionId(String value) async {
  prefs.setString(_sessionId, value);
}

String getTabelNumber() {
  return prefs.getString(_tableNumber) ?? '';
}

Future<void> setTableNumber(String value) async {
  prefs.setString(_tableNumber, value);
}

String getCustomerName() {
  return prefs.getString(_customerName) ?? '';
}

Future<void> setCustomerName(String value) async {
  prefs.setString(_customerName, value);
}

String getTotalOrder() {
  return prefs.getString(_totalOrder) ?? '';
}

Future<void> setTotalOrder(String value) async {
  prefs.setString(_totalOrder, value);
}

String getOrderDate() {
  return prefs.getString(_dateOrder) ?? '';
}

Future<void> setOrderDate(String value) async {
  prefs.setString(_dateOrder, value);
}

String getBranchPref() {
  return prefs.getString(_branch) ?? '';
}

Future<void> setBranch(String value) async {
  prefs.setString(_branch, value);
}

String getBrand() {
  return prefs.getString(_brand) ?? '';
}

Future<void> setBrand(String value) async {
  prefs.setString(_brand, value);
}

String getToken() {
  return prefs.getString(_token) ?? '';
}

Future<void> setToken(String value) async {
  prefs.setString(_token, value);
}

List<String> getListHistory() {
  return prefs.getStringList(_listHistory) ?? [];
}

Future<void> setListHistory(List<String> value) async {
  prefs.setStringList(_listHistory, value);
}

int getPaymentMode() {
  return prefs.getInt(_paymentMethod) ?? defaultBillTable;
}

Future<void> setPaymentMode(int value) async {
  prefs.setInt(_paymentMethod, value);
}

String getLogoUrl() {
  return prefs.getString(_logo) ?? '';
}

Future<void> setLogoUrl(String value) async {
  prefs.setString(_logo, value);
}

String getRole() {
  return prefs.getString(_role) ?? 'customer';
}

Future<void> setRole(String value) async {
  prefs.setString(_role, value);
}

String getCashierName() {
  return prefs.getString(_cashierName) ?? '';
}

Future<void> setCashierName(String value) async {
  prefs.setString(_cashierName, value);
}

String getUrlLookUp() {
  return prefs.getString(_urlLookUp) ?? '';
}

Future<void> setUrlLookUp(String value) async {
  prefs.setString(_urlLookUp, value);
}

String getLatitude() {
  return prefs.getString(_latitude) ?? '';
}

Future<void> setLatitude(String value) async {
  prefs.setString(_latitude, value);
}

String getLongitude() {
  return prefs.getString(_longitude) ?? '';
}

Future<void> setLongitude(String value) async {
  prefs.setString(_longitude, value);
}

String getTitleWeb() {
  return prefs.getString(_titleWeb) ?? '';
}

Future<void> setTitleWeb(String value) async {
  prefs.setString(_titleWeb, value);
}

bool getIsDeliveryPickup() {
  return prefs.getBool(_isDeliveryPickup) ?? false;
}

Future<void> setIsDeliveryPickup(bool value) async {
  prefs.setBool(_isDeliveryPickup, value);
}

int getUrlType() {
  return prefs.getInt(_typeUrl) ?? 0; // 0 biar error kalau belum di set
}

Future<void> setUrlType(int value) async {
  prefs.setInt(_typeUrl, value);
}

List<String> getListTypeUrl() {
  return prefs.getStringList(_listTypeUrl) ?? [];
}

Future<void> setListTypeUrl(List<String> value) async {
  prefs.setStringList(_listTypeUrl, value);
}

int getTypeOrder() {
  return prefs.getInt(_orderType) ?? -1; // -1 biar ketahuan kalau ada error
}

Future<void> setTypeOrder(int value) async {
  prefs.setInt(_orderType, value);
}

bool getIsPickup() {
  return prefs.getBool(_isPickup) ?? false;
}

Future<void> setIsPickup(bool value) async {
  prefs.setBool(_isPickup, value);
}

bool getIsDelivery() {
  return prefs.getBool(_isDelivery) ?? false;
}

Future<void> setIsDelivery(bool value) async {
  prefs.setBool(_isDelivery, value);
}

bool getIsCustomerDelivery() {
  return prefs.getBool(_isCustomerDelivery) ?? false;
}

Future<void> setIsCustomerDelivery(bool value) async {
  prefs.setBool(_isCustomerDelivery, value);
}

String getMqMessage() {
  return prefs.getString(_mqMessage) ?? 'default';
}

Future<void> setMqMessage(String value) async {
  prefs.setString(_mqMessage, value);
}

int getTableMode() {
  return prefs.getInt(_tableMode) ?? 0;
}

Future<void> setTableMode(int value) async {
  prefs.setInt(_tableMode, value);
}

String getBranchName() {
  return prefs.getString(_branchName) ?? '';
}

Future<void> setBranchName(String value) async {
  prefs.setString(_branchName, value);
}

bool getStatusOrderCreated() {
  return prefs.getBool(_orderCreated) ?? false;
}

Future<void> setStatusOrderCreated(bool value) async {
  prefs.setBool(_orderCreated, value);
}

String getLatOutlet() {
  return prefs.getString(_latOutlet) ?? '';
}

Future<void> setLatOutlet(String value) async {
  prefs.setString(_latOutlet, value);
}

String getLongOutlet() {
  return prefs.getString(_longOutlet) ?? '';
}

Future<void> setLongOutlet(String value) async {
  prefs.setString(_longOutlet, value);
}

String getOpenTime() {
  return prefs.getString(_openTime) ?? '';
}

Future<void> setOpenTime(String value) async {
  prefs.setString(_openTime, value);
}

String getCloseTime() {
  return prefs.getString(_closeTime) ?? '';
}

Future<void> setCloseTime(String value) async {
  prefs.setString(_closeTime, value);
}

String getPickupTime() {
  return prefs.getString(_pickupTime) ?? '';
}

Future<void> setPickupTime(String value) async {
  prefs.setString(_pickupTime, value);
}
