import 'package:flutter/material.dart';
import 'package:flutter_easyloading/flutter_easyloading.dart';

import '../../models/orders.dart';
import '../../ui/checkout/fuction.dart';
import '../helper.dart';
import 'style.dart';

// ignore: non_constant_identifier_names
AnimatedContainer CoreModalInputName(BuildContext context,
    TextEditingController nameController, List<Orders> listOrders) {
  return AnimatedContainer(
    duration: const Duration(milliseconds: 300),
    child: AlertDialog(
      scrollable: true,
      title: defaultText(
        context,
        "Masukkan Nama",
        style: modalNamaHeader(),
      ),
      content: SizedBox(
        height: 216,
        width: 303,
        child: Column(
          children: [
            TextField(
              keyboardType: TextInputType.text,
              controller: nameController,
              style: const TextStyle(
                fontFamily: 'OpenSans',
                fontSize: 14,
                color: textColorModalHeaderNama,
              ),
              decoration: const InputDecoration(
                labelText: 'Nama panggilan',
                labelStyle: TextStyle(
                  fontFamily: 'OpenSans',
                  fontSize: 14,
                  color: textColorModalHeaderNama,
                ),
              ),
            ),
            const SizedBox(
              height: 47,
            ),
            GestureDetector(
              onTap: () {
                if (nameController.text != '') {
                  checkOut(context, listOrders, nameController.text);
                } else {
                  EasyLoading.showToast("Nama wajib diisi");
                }
              },
              child: Container(
                height: 43,
                decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(31),
                    color: buttonColor),
                child: Center(
                  child: defaultText(
                    context,
                    "Simpan",
                    style: simpanButtonNote(
                      font: 14,
                      fontWeight: FontWeight.w600,
                    ),
                  ),
                ),
              ),
            ),
            const SizedBox(
              height: 20,
            ),
            GestureDetector(
              onTap: () {
                Navigator.pop(context);
              },
              child: Container(
                height: 43,
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(31),
                  color: Colors.transparent,
                ),
                child: Center(
                  child: defaultText(
                    context,
                    "Batal",
                    style: simpanButtonNote(
                      font: 14,
                      fontWeight: FontWeight.w600,
                      color: textColorRed,
                    ),
                  ),
                ),
              ),
            ),
          ],
        ),
      ),
    ),
  );
}
