import 'package:byod/helper/helper.dart';
import 'package:flutter/material.dart';

// import '../../models/category_list.dart';
String fontFamily = 'K2D';

Text defaultText(
  BuildContext context,
  String text, {
  TextStyle? style,
  int? maxLines,
  TextOverflow? overFlow,
  TextAlign? textAlign,
  Key? key,
}) {
  return Text(
    text,
    key: (key != null) ? key : null,
    textScaleFactor: textScaleFactor,
    maxLines: (maxLines != null) ? maxLines : null,
    overflow: (overFlow != null) ? overFlow : null,
    textAlign: (textAlign != null) ? textAlign : null,
    style: (style != null) ? style : null,
  );
}

TextStyle appBarNameVariant({font = 17, Color color = textColorBlack}) {
  return TextStyle(
    fontFamily: 'Mulish',
    fontSize: font,
    fontWeight: FontWeight.w700,
    color: color,
  );
}

TextStyle emojiStyle({
  font = 14,
  Color color = textColorBlack,
  FontWeight fontWeight = FontWeight.w600,
}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: font,
    fontWeight: fontWeight,
    color: color,
  );
}

TextStyle textStyleDialog({
  font = 14,
  Color color = textColorBlack,
  FontWeight fontWeight = FontWeight.w400,
  FontStyle? fontStyle,
}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: font,
    fontWeight: fontWeight,
    color: color,
    fontStyle: fontStyle,
  );
}

TextStyle historyOrderStyle({
  font = 12,
  Color color = textColorBlack,
  FontWeight fontWeight = FontWeight.w400,
}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: font,
    fontWeight: fontWeight,
    color: color,
  );
}

TextStyle appBarNameViewBill({font = 17, Color color = textColorBlack}) {
  return TextStyle(
    fontFamily: 'Mulish',
    fontSize: font,
    fontWeight: FontWeight.w700,
    color: color,
  );
}

TextStyle menuNameListViewBill({font = 17, Color color = textColorBlack}) {
  return TextStyle(
    fontFamily: 'Mulish',
    fontSize: font,
    fontWeight: FontWeight.w700,
    color: color,
  );
}

TextStyle descriptionListViewBill(
    {font = 14, Color color = textColorPlaceHolder}) {
  return TextStyle(
    fontFamily: 'Mulish',
    fontSize: font,
    fontWeight: FontWeight.w400,
    color: color,
  );
}

TextStyle viewbillStyle(
    {font = 16,
    Color color = textColorBlack,
    FontWeight fontWeight = FontWeight.w400}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: font,
    fontWeight: fontWeight,
    color: color,
  );
}

TextStyle customerNameViewbill({font = 14, Color color = textColorBlack}) {
  return TextStyle(
    fontFamily: 'OpenSans',
    fontSize: font,
    fontWeight: FontWeight.w400,
    color: color,
  );
}

TextStyle pickUpdeliveryStyleFont({font = 16, Color color = textColorBlack}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: font,
    fontWeight: FontWeight.w600,
    color: color,
  );
}

TextStyle noteViewBill({font = 8, Color color = textColorBlack}) {
  return TextStyle(
    fontFamily: 'OpenSans',
    fontSize: font,
    fontWeight: FontWeight.w400,
    color: color,
  );
}

TextStyle tableNameStyle({font = 20, Color color = textColorTabel}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: font,
    fontWeight: FontWeight.w400,
    color: color,
  );
}

TextStyle favNameStyle({font = 14, Color color = textColorBlack}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: font,
    fontWeight: FontWeight.w600,
    color: color,
  );
}

TextStyle catNameStyle({font = 12, Color color = textColorBlack}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: font,
    fontWeight: FontWeight.w700,
    color: color,
  );
}

TextStyle menuNameGridFav(
    {font = 12, Color color = textColorBlack, String fontFamilyStyle = ''}) {
  return TextStyle(
    fontFamily: 'Roboto',
    fontSize: font,
    fontWeight: FontWeight.w600,
    color: color,
  );
}

TextStyle menuPriceGridFav({
  font = 10,
  Color color = textColorBlack,
}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: font,
    fontWeight: FontWeight.w400,
    color: color,
  );
}

TextStyle addButtonGridFav({
  font = 12,
  Color color = textInButton,
}) {
  return TextStyle(
    fontFamily: 'OpenSans',
    fontSize: font,
    fontWeight: FontWeight.w400,
    color: color,
  );
}

TextStyle amountGridFav({
  font = 12,
  Color color = textColorBlack,
}) {
  return TextStyle(
    fontFamily: 'OpenSans',
    fontSize: font,
    fontWeight: FontWeight.w500,
    color: color,
  );
}

TextStyle amountViewBillButton({
  font = 17,
  Color color = textColorBlack,
}) {
  return TextStyle(
    fontFamily: 'Mulish',
    fontSize: font,
    fontWeight: FontWeight.w400,
    color: color,
  );
}

TextStyle categoryStyle({
  font = 14,
  Color color = textColorBlack,
}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: font,
    fontWeight: FontWeight.w600,
    color: color,
  );
}

TextStyle subCategoryStyle({
  font = 28,
  Color color = textColorBlack,
}) {
  return TextStyle(
    fontFamily: 'Roboto',
    fontSize: font,
    fontWeight: FontWeight.w600,
    color: color,
  );
}

TextStyle categoryNameStyle({
  font = 20,
  Color color = textColorBlack,
}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: font,
    fontWeight: FontWeight.w600,
    color: color,
  );
}

TextStyle menuNameStyle({
  font = 16,
  Color color = textColorBlack,
}) {
  return TextStyle(
    fontFamily: 'Roboto',
    fontSize: font,
    fontWeight: FontWeight.w600,
    color: color,
  );
}

TextStyle deskripsiMenuStyle({
  font = 12,
  Color color = textColorBlack,
}) {
  return TextStyle(
    fontFamily: 'Roboto',
    fontSize: font,
    fontWeight: FontWeight.w300,
    color: color,
  );
}

TextStyle amountMenuStyle({
  font = 16,
  Color color = textColorBlack,
  FontWeight fontWeight = FontWeight.w300,
}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: font,
    fontWeight: fontWeight,
    color: color,
  );
}

TextStyle addButton({
  font = 12,
  Color color = textInButton,
}) {
  return TextStyle(
    fontFamily: 'OpenSans',
    fontSize: font,
    fontWeight: FontWeight.w400,
    color: color,
  );
}

TextStyle addressStyle({
  font = 14,
  Color color = textColorBlack,
}) {
  return TextStyle(
    fontFamily: 'OpenSans',
    fontSize: font,
    fontWeight: FontWeight.w400,
    color: color,
  );
}

TextStyle rincianPembayaran({
  font = 12,
  Color color = textColorBlack,
  FontWeight fontWeight = FontWeight.w400,
  FontStyle? fontStyle,
}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: font,
    fontWeight: fontWeight,
    color: color,
    fontStyle: fontStyle,
  );
}

TextStyle buttonBottomBill(
    {font = 14,
    Color color = textInButton,
    FontWeight fontWeight = FontWeight.w400}) {
  return TextStyle(
    fontFamily: 'OpenSans',
    fontSize: font,
    fontWeight: fontWeight,
    color: color,
  );
}

TextStyle addButtonBottomCart({
  font = 16,
  Color color = textInButton,
}) {
  return TextStyle(
    fontFamily: 'Roboto',
    fontSize: font,
    fontWeight: FontWeight.w600,
    color: color,
  );
}

TextStyle textAmountButtonBottomCart({
  font = 16,
  Color color = textInButton,
}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: font,
    fontWeight: FontWeight.w300,
    color: color,
  );
}

TextStyle textStyleVariantModal({
  font = 12,
  Color color = textColorBlack,
  FontWeight fontWeight = FontWeight.w300,
}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: font,
    fontWeight: fontWeight,
    color: color,
  );
}

TextStyle textCountItem({
  font = 20,
  Color color = textInButton,
}) {
  return TextStyle(
    fontFamily: 'Roboto',
    fontSize: font,
    fontWeight: FontWeight.w500,
    color: color,
  );
}

TextStyle textHeaderNote({
  font = 20,
  Color color = textColorBlack,
}) {
  return TextStyle(
    fontFamily: 'Mulish',
    fontSize: font,
    fontWeight: FontWeight.w700,
    color: color,
  );
}

TextStyle simpanButtonNote({
  font = 16,
  Color color = textInButton,
  FontWeight fontWeight = FontWeight.w400,
}) {
  return TextStyle(
    fontFamily: 'OpenSans',
    fontSize: font,
    fontWeight: fontWeight,
    color: color,
  );
}

TextStyle modalNamaHeader({
  font = 14,
  Color color = textColorModalHeaderNama,
}) {
  return TextStyle(
    fontFamily: 'OpenSans',
    fontSize: font,
    fontWeight: FontWeight.w400,
    color: color,
  );
}

TextStyle modalPaymentStyle({
  font = 18,
  Color color = textColorBlack,
  FontWeight fontWeight = FontWeight.w600,
}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: font,
    fontWeight: fontWeight,
    color: color,
  );
}

Text fontAwesome(BuildContext context, String unicode, double fontSize,
    {Color? color, isBold = true}) {
  // double widthScreens = responsiveWidthScreen(context);
  double fontSizeResponsive = MediaQuery.of(context).size.height * fontSize;
  return Text(
    unicode,
    style: TextStyle(
      fontFamily: 'FontAwesome',
      fontSize: fontSizeResponsive,
      color: color,
      fontWeight: (isBold) ? FontWeight.w600 : FontWeight.w400,
    ),
  );
}

Text fontAwesomeNew(String unicode, double fontSize,
    {Color? color, isBold = true}) {
  return Text(
    unicode,
    style: TextStyle(
      fontFamily: 'FontAwesome',
      fontSize: fontSize,
      color: color,
      fontWeight: (isBold) ? FontWeight.w600 : FontWeight.w400,
    ),
  );
}

Text fontAwesomeCart(BuildContext context, String unicode, double fontSize,
    {Color? color, isBold = true}) {
  // double widthScreens = responsiveWidthScreen(context);
  // double fontSizeResponsive = MediaQuery.of(context).size.height * fontSize;
  return Text(
    unicode,
    style: TextStyle(
      fontFamily: 'FontAwesome',
      fontSize: fontSize,
      color: color,
      fontWeight: (isBold) ? FontWeight.w600 : FontWeight.w400,
    ),
  );
}

Text textCategory(BuildContext context, String text) {
  return defaultText(context, text, style: textStyleCategoryMenu(context));
}

Text textGroup(BuildContext context, String text) {
  return defaultText(
    context,
    text,
    style: textStyleGroup(context),
  );
}

Text textMenuList(BuildContext context, String text) {
  // return Text(
  //   text,
  //   maxLines: 3,
  //   textScaleFactor: textScaleFactor,
  //   overflow: TextOverflow.ellipsis,
  //   style: textStyleMenuList(context),
  // );
  return defaultText(
    context,
    text,
    maxLines: 3,
    overFlow: TextOverflow.ellipsis,
    style: textStyleMenuList(context),
  );
}

Text textMenuDescription(BuildContext context, String text) {
  // return Text(
  //   text,
  //   maxLines: 3,
  //   textScaleFactor: textScaleFactor,
  //   overflow: TextOverflow.ellipsis,
  //   style: textStyleMenuList(context),
  // );
  return defaultText(
    context,
    text,
    maxLines: 2,
    overFlow: TextOverflow.ellipsis,
    style: textStyleMenuDescription(context),
  );
}

Text textAmountMenu(BuildContext context, int amount) {
  return defaultText(context, formatNumber().format(amount),
      overFlow: TextOverflow.clip,
      style: textStyleAmount(
        context,
        font: normalFont,
      ));
  // return Text(
  //   formatNumber().format(amount),
  //   overflow: TextOverflow.clip,
  //   textScaleFactor: textScaleFactor,
  //   style: textStyleAmount(
  //     context,
  //     font: normalFont,
  //   ),
  // );
}

TextStyle textDeskripsiHeader() {
  return const TextStyle(
    fontFamily: 'Roboto',
    fontWeight: FontWeight.w500,
    fontSize: 14,
    color: textColorBlack,
  );
}

TextStyle textDeskripsi() {
  return const TextStyle(
    fontFamily: 'Roboto',
    fontWeight: FontWeight.w400,
    fontSize: 14,
    color: textGreyDeskripsi,
  );
}

Text textAmountCoret(BuildContext context, int hargaCoret) {
  return defaultText(
    context,
    formatNumber().format(hargaCoret),
    overFlow: TextOverflow.clip,
    style: textStyleAmount(
      context,
      textColor: Colors.black45,
      decoration: TextDecoration.lineThrough,
    ),
  );
  // return Text(
  //   formatNumber().format(hargaCoret),
  //   overflow: TextOverflow.clip,
  //   style: textStyleAmount(
  //     context,
  //     textColor: Colors.black45,
  //     decoration: TextDecoration.lineThrough,
  //   ),
  // );
}

Text textAmoutBottomShetModalMenu(BuildContext context, int amount) {
  return defaultText(
    context,
    formatNumber().format(amount),
    overFlow: TextOverflow.clip,
    style: textStyleAmount(
      context,
      font: normalFont,
    ),
  );
  // return Text(
  //   formatNumber().format(amount),
  //   overflow: TextOverflow.clip,
  //   style: textStyleAmount(
  //     context,
  //     font: normalFont,
  //   ),
  // );
}

Text textMenuNameBottomShetModalMenu(BuildContext context, String text) {
  return defaultText(
    context,
    text,
    maxLines: 2,
    overFlow: TextOverflow.ellipsis,
    style: menuNameBottomSheet(),
  );
  // return Text(
  //   text,
  //   maxLines: 2,
  //   overflow: TextOverflow.ellipsis,
  //   style: textStyleMenuList(context),
  // );
}

TextStyle menuNameBottomSheet() {
  return const TextStyle(
    fontFamily: 'Roboto',
    fontWeight: FontWeight.w500,
    fontSize: 28,
    color: textColorBlack,
  );
}

Text textDescriptionBottomShetModalMenu(BuildContext context, String text) {
  return defaultText(
    context,
    text,
    maxLines: 5,
    overFlow: TextOverflow.ellipsis,
    style: textStyleMenuDescription(context),
  );
  // return Text(
  //   text,
  //   maxLines: 2,
  //   overflow: TextOverflow.ellipsis,
  //   style: textStyleMenuList(context),
  // );
}

Text textAddButton(BuildContext context, String text) {
  return defaultText(
    context,
    text,
    style: textStyleAddButton(
      context,
      color: textInButton,
    ),
  );
  // return Text(text,
  //     style: textStyleAddButton(
  //       context,
  //       color: textInButton,
  //     ));
}

TextStyle noteModal() {
  return const TextStyle(
    fontFamily: 'OpenSans',
    fontWeight: FontWeight.w400,
    color: textColorBlack,
    fontSize: 14,
  );
}

TextStyle textStyleListHistoryOrder(context,
    {font = listHistoryFontName, isBold = false}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: MediaQuery.of(context).size.height * font,
    fontWeight: (isBold) ? FontWeight.w600 : FontWeight.w400,
  );
}

TextStyle textStyleCategoryMenu(context, {font = categoryFont}) {
  return TextStyle(
      fontFamily: (fontFamily == '') ? null : fontFamily,
      fontSize: MediaQuery.of(context).size.height * font,
      fontWeight: FontWeight.w600);
}

TextStyle textStyleGroup(context, {font = groupFont}) {
  return TextStyle(
      fontFamily: (fontFamily == '') ? null : fontFamily,
      fontSize: MediaQuery.of(context).size.height * font,
      fontWeight: FontWeight.w600);
}

TextStyle textStyleNormalFont(
  context, {
  font = normalFont,
  Color? color,
  FontStyle? fontStyle,
  bool isBold = false,
}) {
  // double widtScreens = responsiveWidthScreen(context);
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: MediaQuery.of(context).size.height * font,
    fontWeight: (!isBold) ? FontWeight.w400 : FontWeight.w600,
    color: (color == null) ? null : color,
    fontStyle: (fontStyle == null) ? null : fontStyle,
  );
}

TextStyle textStyleAddButton(
  context, {
  font = normalFont,
  Color? color,
  FontStyle? fontStyle,
  bool isBold = false,
}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: MediaQuery.of(context).size.height * font,
    fontWeight: (!isBold) ? FontWeight.w400 : FontWeight.w600,
    color: (color == null) ? null : color,
    fontStyle: (fontStyle == null) ? null : fontStyle,
  );
}

TextStyle variantStyleText(
    {Color? textColor,
    TextDecoration? decoration,
    font = 20,
    FontWeight? fontWeight}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: font,
    fontWeight: (fontWeight == null) ? FontWeight.w600 : fontWeight,
    color: (textColor == null) ? null : textColorBlack,
    decoration: (decoration == null) ? null : decoration,
  );
}

TextStyle textStyleRefresh(context) {
  return TextStyle(
      fontFamily: (fontFamily == '') ? null : fontFamily,
      fontSize: MediaQuery.of(context).size.height * refreshFont,
      color: textInButton);
}

TextStyle textStyleTambahPesanan(context) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: MediaQuery.of(context).size.height * addMoreFont,
    color: textInButton,
  );
}

// TextStyle textStyleVersionNumber(context) {
//   return TextStyle(
//     fontFamily: (fontFamily == '') ? null : fontFamily,
//     fontSize: MediaQuery.of(context).size.height * versionFont,
//     color: Colors.black54,
//     fontStyle: FontStyle.italic,
//   );
// }

TextStyle textStyleVersionNumber({
  font = 10,
  Color color = Colors.black54,
  FontWeight fontWeight = FontWeight.w400,
  FontStyle? fontStyle,
}) {
  return TextStyle(
    fontFamily: 'OpenSans',
    fontSize: font,
    fontWeight: fontWeight,
    color: color,
    fontStyle: fontStyle,
  );
}

TextStyle textStyleVoucherListAddMore(context) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: MediaQuery.of(context).size.height * moreValueVoucher,
    color: Colors.black54,
    fontStyle: FontStyle.italic,
  );
}

TextStyle textStyleVoucherMinTrans(context, {Color? textColor}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: MediaQuery.of(context).size.height * minTransFont,
    color: (textColor == null) ? null : textColor,
    fontStyle: FontStyle.italic,
  );
}

TextStyle textStyleMenuList(context,
    {Color? textColor, TextDecoration? decoration, font = menuFont}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: MediaQuery.of(context).size.height * font,
    fontWeight: FontWeight.w600,
    color: (textColor == null) ? null : textColor,
    decoration: (decoration == null) ? null : decoration,
  );
}

TextStyle textStyleMenuDescription(context,
    {Color? textColor, TextDecoration? decoration, font = descriptionFont}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: MediaQuery.of(context).size.height * font,
    fontWeight: FontWeight.w400,
    color: (textColor == null) ? null : textColor,
    decoration: (decoration == null) ? null : decoration,
  );
}

TextStyle textStyleTitleReward(context,
    {Color? textColor,
    TextDecoration? decoration,
    font = voucherListFont,
    isBold = false}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: MediaQuery.of(context).size.height * font,
    fontWeight: (isBold) ? FontWeight.w600 : FontWeight.w400,
    color: (textColor == null) ? null : textColor,
    decoration: (decoration == null) ? null : decoration,
  );
}

TextStyle textStyleAmount(context,
    {Color? textColor, TextDecoration? decoration, font = normalFont}) {
  return TextStyle(
    fontFamily: (fontFamily == '') ? null : fontFamily,
    fontSize: MediaQuery.of(context).size.height * font,
    fontWeight: FontWeight.w500,
    color: (textColor == null) ? null : textColor,
    decoration: (decoration == null) ? null : decoration,
  );
}

TextStyle textStyleSelectedCategory(BuildContext context) {
  return TextStyle(
    fontSize: MediaQuery.of(context).size.height * categoryListFont,
    color: textInButton,
    fontWeight: FontWeight.w600,
  );
}

Container buttonBottom(
    BuildContext context, String text, Color colorButton, double widthButton,
    {Color colorText = textInButton}) {
  double widhtScreen = responsiveWidthScreen(context);
  return Container(
    height: MediaQuery.of(context).size.height * heigthButtonBottom,
    width: widhtScreen * widthButton,
    decoration: BoxDecoration(
      borderRadius: BorderRadius.circular(roundedButton),
      color: colorButton,
    ),
    child: Container(
      margin: const EdgeInsets.all(5),
      // color: Colors.red,
      child: Align(
          alignment: Alignment.center,
          child: Text(
            text,
            // style: TextStyle(
            //     fontWeight: FontWeight.w500,
            //     fontSize: 18,
            //     color: textInButton),
            style: textStyleNormalFont(context, color: colorText),
          )),
    ),
  );
}
