class Branch {
  final String id;
  final String branchCode;
  final String name;
  final String image;
  final String logo;
  final bool isDineIn;
  final bool isDelivery;
  final bool isPickup;
  final double distance;

  Branch({
    required this.id,
    required this.branchCode,
    required this.name,
    required this.image,
    required this.logo,
    required this.isDineIn,
    required this.isDelivery,
    required this.isPickup,
    required this.distance,
  });

  factory Branch.json(Map<String, dynamic> json) {
    return Branch(
      id: json['id'],
      branchCode: json['code'],
      name: json['name'],
      image: json['image'],
      logo: json['logo'],
      isDineIn: json['is_dinein'],
      isDelivery: json['is_delivery'],
      isPickup: json['is_pickup'],
      distance: json['distance'],
    );
  }
}
