import 'package:byod/models/variant_categories.dart';

class FavMenu {
  final String id;
  final String name;
  final String price;
  final String originalPrice;
  final String imageUrlMedium;
  final String imageUrlThumbnail;
  final bool isSell;
  final String favGroupId;
  final String description;
  final String favGroupName;
  List<VariantCategories> variantCat;

  FavMenu(
      {required this.id,
      required this.name,
      required this.price,
      required this.originalPrice,
      required this.imageUrlMedium,
      required this.imageUrlThumbnail,
      required this.isSell,
      required this.favGroupId,
      required this.description,
      required this.favGroupName,
      this.variantCat = const []});

  factory FavMenu.createFav(Map<String, dynamic> json) {
    return FavMenu(
        id: json['id'],
        name: json['name'],
        price: json['price'],
        originalPrice: json['original_price'],
        imageUrlMedium: json['image_medium'],
        imageUrlThumbnail: json['image_thumbnail'],
        isSell: json['sold_in_store'],
        favGroupId: json['favorite_group_id'],
        description: json['description'],
        favGroupName: json['favorite_group_name'],
        variantCat: json['variant_cat']);
  }
}
