import 'package:byod/models/variant_categories.dart';

class Menu {
  final String id;
  final String name;
  final String price;
  final String originalPrice;
  final String imageUrlMedium;
  final String imageUrlThumbnail;
  final bool isSell;
  List<VariantCategories> variantCat;

  Menu(
      {required this.id,
      required this.name,
      required this.price,
      required this.originalPrice,
      required this.imageUrlMedium,
      required this.imageUrlThumbnail,
      required this.isSell,
      this.variantCat = const []});

  factory Menu.createMenu(Map<String, dynamic> json) {
    return Menu(
        id: json['id'],
        name: json['name'],
        price: json['price'],
        originalPrice: json['original_price'],
        imageUrlMedium: json['image_medium'],
        imageUrlThumbnail: json['image_thumbnail'],
        isSell: json['sold_in_store'],
        variantCat: json['variant_cat']);
  }
}
