// ignore_for_file: sized_box_for_whitespace
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import '../../helper/helper.dart';
import '../../helper/widget/style.dart';
import '../bloc/branch_list.dart';
import '../bloc/search_branch.dart';
import '../models/branchs.dart';

class CustomAppBar extends StatelessWidget {
  CustomAppBar({
    Key? key,
    // required this.allBranch,
  }) : super(key: key);

  // final List<Branch> allBranch;
  final _searchController = TextEditingController();
  @override
  Widget build(BuildContext context) {
    return Container(
      color: backgroundWhite,
      padding: const EdgeInsets.symmetric(
          horizontal: paddingLeftRight, vertical: 15),
      child: Column(
        children: [
          Center(
            child: defaultText(
              context,
              'Silahkan Pilih Outlet',
              maxLines: 1,
              overFlow: TextOverflow.ellipsis,
              style: appBarNameViewBill(),
            ),
          ),
          const SizedBox(
            height: 16,
          ),
          BlocBuilder<BranchList, List<Branch>>(
            builder: (context, allBranch) {
              return Container(
                height: 36,
                child: TextField(
                  controller: _searchController,
                  // autofocus: true,
                  onChanged: (searchValue) {
                    context.read<SearchBranch>().search(searchValue, allBranch);
                  },
                  key: const Key('SearchField'),
                  style: TextStyle(
                    color: Colors.black,
                    fontFamily: fontFamily,
                    fontSize: 15,
                  ),
                  decoration: InputDecoration(
                    filled: true,
                    fillColor: Colors.white,
                    enabledBorder: OutlineInputBorder(
                      borderSide: BorderSide(
                        width: 1,
                        color: Colors.grey.withOpacity(0.8),
                      ),
                    ),
                    focusedBorder: OutlineInputBorder(
                      borderSide: BorderSide(
                        width: 1,
                        color: buttonColor,
                      ),
                    ),
                    prefixIcon: Image(
                      image: const AssetImage('assets/icons/search.png'),
                      color: Colors.grey.withOpacity(0.8),
                      height: 20,
                      width: 20,
                    ),
                    hintText: 'Excelso Puri Indah Mall',
                    hintStyle: TextStyle(
                      color: Colors.grey.withOpacity(0.8),
                      fontFamily: fontFamily,
                      fontSize: 10,
                    ),
                    border: OutlineInputBorder(
                      borderRadius: BorderRadius.circular(6),
                    ),
                  ),
                ),
              );
            },
          ),
        ],
      ),
    );
  }
}
