// ignore_for_file: sized_box_for_whitespace

import 'package:byod/helper/helper.dart';
import 'package:byod/helper/widget/style.dart';
import 'package:byod/ui/screen_responsive.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../bloc/order_bloc.dart';
import '../../helper/prefs.dart';
import '../../helper/widget/button_modal.dart';
import '../../helper/widget/modal_input_name.dart';
import '../../models/orders.dart';
import '../checkout/fuction.dart';
import 'app_bar_confirm.dart';

class ConfirmOrder extends StatelessWidget {
  const ConfirmOrder({super.key});

  @override
  Widget build(BuildContext context) {
    return SafeArea(
        child: Scaffold(
      backgroundColor: backgroundColor,
      body: ScreenResponsive(
        widget: CoreConfirm(),
        widthScreen: MediaQuery.of(context).size.width,
        isCoreLayout: true,
      ),
    ));
  }
}

class CoreConfirm extends StatelessWidget {
  CoreConfirm({super.key});

  final nameController = TextEditingController();
  @override
  Widget build(BuildContext context) {
    double widthScreen = responsiveWidthScreen(context);
    return BlocBuilder<OrdersBloc, List<Orders>>(
      builder: (context, listOrders) {
        int totalHarga = 0;
        List indexTidakAdaVariant = [];
        List indexAdaVariant = [];

        // if (listOrders.isNotEmpty) {
        //   int fixTotalHarga = 0;
        //   int totalHargaOrderDetail = 0;
        //   int totalHargaBukanOrderDetail = 0;
        //   for (var i = 0; i < listOrders.length; i++) {
        //     if (listOrders[i].orderDetail.isEmpty) {
        //       // indexTidakAdaVariant.add(i);
        //       totalHargaBukanOrderDetail +=
        //           (listOrders[i].totalItem * listOrders[i].totalHarga);
        //     } else {
        //       // for (int kk = 0; kk < listOrders[i].orderDetail.length; kk++) {
        //       //   String indexWithVariant = '$i|$kk';
        //       //   indexAdaVariant.add(indexWithVariant);
        //       //   totalHargaOrderDetail +=
        //       //       listOrders[i].orderDetail[kk].totalHarga;
        //       // }
        //       fixTotalHarga = totalHargaOrderDetail;
        //     }
        //   }
        //   totalHarga = fixTotalHarga + totalHargaBukanOrderDetail;
        // }

        if (listOrders.isNotEmpty) {
          int fixTotalHarga = 0;
          int totalHargaOrderDetail = 0;
          int totalHargaBukanOrderDetail = 0;

          // int fixTotalItem = 0;
          // int totalItemOrderDetail = 0;
          // int totalItemBukanOrderDetail = 0;
          for (var i = 0; i < listOrders.length; i++) {
            // totalItem += listOrders[i].totalItem;
            // check apakah ada order detail. kalau ada rekalkulasi total harga sesuai order detail
            if (listOrders[i].orderDetail.isEmpty) {
              indexTidakAdaVariant.add(i);
              totalHargaBukanOrderDetail +=
                  (listOrders[i].totalItem * listOrders[i].totalHarga);
              // totalItemBukanOrderDetail += listOrders[i].totalItem;
            } else {
              for (int kk = 0; kk < listOrders[i].orderDetail.length; kk++) {
                String indexWithVariant =
                    '$i|$kk'; // index orderan|index order detail
                indexAdaVariant.add(indexWithVariant);
                totalHargaOrderDetail +=
                    listOrders[i].orderDetail[kk].totalHarga;
                // totalItemOrderDetail +=
                //     listOrders[i].orderDetail[kk].totalItem;
              }
              fixTotalHarga = totalHargaOrderDetail;
              // fixTotalItem = totalItemOrderDetail;
            }
          }
          totalHarga = fixTotalHarga + totalHargaBukanOrderDetail;
          // totalItem = fixTotalItem + totalItemBukanOrderDetail;
        }

        return Container(
          width: widthScreen,
          child: Stack(
            children: [
              Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  const CustomAppBarConfirm(),
                  Expanded(
                    child: SingleChildScrollView(
                      physics: const AlwaysScrollableScrollPhysics(),
                      child: Column(
                        children: [
                          const SizedBox(
                            height: 24,
                          ),
                          for (var i in indexAdaVariant)
                            Container(
                              child: listWithVariant(
                                listOrders,
                                i,
                                context,
                                indexAdaVariant,
                              ),
                            ),
                          for (int j in indexTidakAdaVariant)
                            Column(
                              children: [
                                Container(
                                  width: double.infinity,
                                  padding: const EdgeInsets.symmetric(
                                    horizontal: paddingLeftRight,
                                    vertical: 16,
                                  ),
                                  color: backgroundWhite,
                                  child: Row(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.center,
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    children: [
                                      (listOrders[j].imageUrl != '')
                                          ? Image(
                                              width: 80,
                                              height: 80,
                                              fit: BoxFit.fill,
                                              image: NetworkImage(
                                                  listOrders[j].imageUrl),
                                            )
                                          : const Image(
                                              width: 80,
                                              height: 80,
                                              fit: BoxFit.fill,
                                              image: AssetImage(
                                                  'assets/noimage.png'),
                                            ),
                                      const SizedBox(
                                        width: 12,
                                      ),
                                      Column(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        mainAxisAlignment:
                                            MainAxisAlignment.center,
                                        children: [
                                          defaultText(
                                            context,
                                            listOrders[j].namaMenu,
                                            maxLines: 2,
                                            overFlow: TextOverflow.ellipsis,
                                            style: menuNameListViewBill(),
                                          ),
                                          const SizedBox(
                                            height: 6,
                                          ),
                                          defaultText(
                                            context,
                                            '${listOrders[j].totalItem} X Rp ${formatNumber().format(listOrders[j].satuanHarga)}',
                                            style: viewbillStyle(
                                              font: 12,
                                              fontWeight: FontWeight.w300,
                                            ),
                                          ),
                                          const SizedBox(
                                            height: 6,
                                          ),
                                          (listOrders[j].note != '')
                                              ? defaultText(
                                                  context,
                                                  "Catatan: ${listOrders[j].note}",
                                                  maxLines: 2,
                                                  overFlow:
                                                      TextOverflow.ellipsis,
                                                  style: viewbillStyle(
                                                    font: 12,
                                                    fontWeight: FontWeight.w300,
                                                  ),
                                                )
                                              : const SizedBox(),
                                          // (listOrders[i]
                                          //         .orderDetail
                                          //         .isNotEmpty)
                                          //     ? defaultText(
                                          //         context,
                                          //         'Variant : ',
                                          //         maxLines: 2,
                                          //         overFlow:
                                          //             TextOverflow.ellipsis,
                                          //         style: viewbillStyle(
                                          //           font: 12,
                                          //           fontWeight:
                                          //               FontWeight.w300,
                                          //         ),
                                          //       )
                                          //     : const SizedBox(),
                                          // if (listOrders[i]
                                          //     .orderDetail
                                          //     .isNotEmpty)
                                          //   for (int a = 0;
                                          //       a < variantCaption.length;
                                          //       a++)
                                          //     if (variantCaption[a] != '')
                                          //       // defaultText(
                                          //       //   context,
                                          //       //   listOrders[i]
                                          //       //       .orderDetail[0]
                                          //       //       .orderVariant[a]
                                          //       //       .name,
                                          //       //   maxLines: 2,
                                          //       //   overFlow:
                                          //       //       TextOverflow.ellipsis,
                                          //       //   style: viewbillStyle(
                                          //       //     font: 12,
                                          //       //     fontWeight:
                                          //       //         FontWeight.w300,
                                          //       //   ),
                                          //       // ),
                                          //       Row(
                                          //         children: [
                                          //           defaultText(
                                          //             context,
                                          //             "${variantCaption[a]} : ",
                                          //             maxLines: 2,
                                          //             overFlow:
                                          //                 TextOverflow.ellipsis,
                                          //             style: viewbillStyle(
                                          //               font: 12,
                                          //               fontWeight:
                                          //                   FontWeight.w300,
                                          //             ),
                                          //           ),
                                          //           defaultText(
                                          //             context,
                                          //             variantName[a],
                                          //             maxLines: 2,
                                          //             overFlow:
                                          //                 TextOverflow.ellipsis,
                                          //             style: viewbillStyle(
                                          //               font: 12,
                                          //               fontWeight:
                                          //                   FontWeight.w300,
                                          //             ),
                                          //           ),
                                          //         ],
                                          //       )
                                        ],
                                      )
                                    ],
                                  ),
                                ),
                                const SizedBox(
                                  height: 24,
                                )
                              ],
                            ),
                          // ListView.builder(
                          //   physics:
                          //       const NeverScrollableScrollPhysics(), // to disable  scrolling
                          //   shrinkWrap: true,
                          //   itemCount: listOrders.length,
                          //   itemBuilder: (context, i) {
                          //     List<String> variantCaption = [];
                          //     List<String> variantName = [];
                          //     int totalItem;
                          //     if (listOrders[i].orderDetail.isNotEmpty) {
                          //       for (int y = 0;
                          //           y <
                          //               listOrders[i]
                          //                   .orderDetail[i]
                          //                   .orderVariant
                          //                   .length;
                          //           y++) {
                          //         int indexCaption = variantCaption.indexWhere(
                          //             (element) =>
                          //                 element ==
                          //                 listOrders[i]
                          //                     .orderDetail[i]
                          //                     .orderVariant[y]
                          //                     .caption);
                          //         if (indexCaption == -1) {
                          //           variantCaption.add(listOrders[i]
                          //               .orderDetail[i]
                          //               .orderVariant[y]
                          //               .caption);
                          //           variantName.add(listOrders[i]
                          //               .orderDetail[i]
                          //               .orderVariant[y]
                          //               .name);
                          //         } else {
                          //           variantName[indexCaption] +=
                          //               ", ${listOrders[i].orderDetail[i].orderVariant[y].name}";
                          //         }
                          //       }
                          //       int totalItemOrderDetail = 0;
                          //       for (int kk = 0;
                          //           kk < listOrders[i].orderDetail.length;
                          //           kk++) {
                          //         totalItemOrderDetail +=
                          //             listOrders[i].orderDetail[kk].totalItem;
                          //       }
                          //       totalItem = totalItemOrderDetail;
                          //     } else {
                          //       totalItem = listOrders[i].totalItem;
                          //     }
                          //     return Column(
                          //       children: [
                          //         Container(
                          //           width: double.infinity,
                          //           padding: const EdgeInsets.symmetric(
                          //             horizontal: paddingLeftRight,
                          //             vertical: 16,
                          //           ),
                          //           color: backgroundWhite,
                          //           child: Row(
                          //             crossAxisAlignment:
                          //                 CrossAxisAlignment.center,
                          //             mainAxisAlignment:
                          //                 MainAxisAlignment.start,
                          //             children: [
                          //               (listOrders[i].imageUrl != '')
                          //                   ? Image(
                          //                       width: 80,
                          //                       height: 80,
                          //                       fit: BoxFit.fill,
                          //                       image: NetworkImage(
                          //                           listOrders[i].imageUrl),
                          //                     )
                          //                   : const Image(
                          //                       width: 80,
                          //                       height: 80,
                          //                       fit: BoxFit.fill,
                          //                       image: AssetImage(
                          //                           'assets/noimage.png'),
                          //                     ),
                          //               const SizedBox(
                          //                 width: 12,
                          //               ),
                          //               Column(
                          //                 crossAxisAlignment:
                          //                     CrossAxisAlignment.start,
                          //                 mainAxisAlignment:
                          //                     MainAxisAlignment.center,
                          //                 children: [
                          //                   defaultText(
                          //                     context,
                          //                     listOrders[i].namaMenu,
                          //                     maxLines: 2,
                          //                     overFlow: TextOverflow.ellipsis,
                          //                     style: menuNameListViewBill(),
                          //                   ),
                          //                   const SizedBox(
                          //                     height: 6,
                          //                   ),
                          //                   defaultText(
                          //                     context,
                          //                     '$totalItem X Rp ${formatNumber().format(listOrders[i].satuanHarga)}',
                          //                     style: viewbillStyle(
                          //                       font: 12,
                          //                       fontWeight: FontWeight.w300,
                          //                     ),
                          //                   ),
                          //                   const SizedBox(
                          //                     height: 6,
                          //                   ),
                          //                   (listOrders[i].note != '')
                          //                       ? defaultText(
                          //                           context,
                          //                           "Catatan: ${listOrders[i].note}",
                          //                           maxLines: 2,
                          //                           overFlow:
                          //                               TextOverflow.ellipsis,
                          //                           style: viewbillStyle(
                          //                             font: 12,
                          //                             fontWeight:
                          //                                 FontWeight.w300,
                          //                           ),
                          //                         )
                          //                       : const SizedBox(),
                          //                   // (listOrders[i]
                          //                   //         .orderDetail
                          //                   //         .isNotEmpty)
                          //                   //     ? defaultText(
                          //                   //         context,
                          //                   //         'Variant : ',
                          //                   //         maxLines: 2,
                          //                   //         overFlow:
                          //                   //             TextOverflow.ellipsis,
                          //                   //         style: viewbillStyle(
                          //                   //           font: 12,
                          //                   //           fontWeight:
                          //                   //               FontWeight.w300,
                          //                   //         ),
                          //                   //       )
                          //                   //     : const SizedBox(),
                          //                   if (listOrders[i]
                          //                       .orderDetail
                          //                       .isNotEmpty)
                          //                     for (int a = 0;
                          //                         a < variantCaption.length;
                          //                         a++)
                          //                       if (variantCaption[a] != '')
                          //                         // defaultText(
                          //                         //   context,
                          //                         //   listOrders[i]
                          //                         //       .orderDetail[0]
                          //                         //       .orderVariant[a]
                          //                         //       .name,
                          //                         //   maxLines: 2,
                          //                         //   overFlow:
                          //                         //       TextOverflow.ellipsis,
                          //                         //   style: viewbillStyle(
                          //                         //     font: 12,
                          //                         //     fontWeight:
                          //                         //         FontWeight.w300,
                          //                         //   ),
                          //                         // ),
                          //                         Row(
                          //                           children: [
                          //                             defaultText(
                          //                               context,
                          //                               "${variantCaption[a]} : ",
                          //                               maxLines: 2,
                          //                               overFlow: TextOverflow
                          //                                   .ellipsis,
                          //                               style: viewbillStyle(
                          //                                 font: 12,
                          //                                 fontWeight:
                          //                                     FontWeight.w300,
                          //                               ),
                          //                             ),
                          //                             defaultText(
                          //                               context,
                          //                               variantName[a],
                          //                               maxLines: 2,
                          //                               overFlow: TextOverflow
                          //                                   .ellipsis,
                          //                               style: viewbillStyle(
                          //                                 font: 12,
                          //                                 fontWeight:
                          //                                     FontWeight.w300,
                          //                               ),
                          //                             ),
                          //                           ],
                          //                         )
                          //                 ],
                          //               )
                          //             ],
                          //           ),
                          //         ),
                          //         const SizedBox(
                          //           height: 24,
                          //         )
                          //       ],
                          //     );
                          //   },
                          // ),
                          const AddMoreOrder()
                        ],
                      ),
                    ),
                  )
                ],
              ),
              Positioned(
                bottom: 0,
                child: Container(
                  decoration: const BoxDecoration(
                    borderRadius: BorderRadius.only(
                      topLeft: Radius.circular(16),
                      topRight: Radius.circular(16),
                    ),
                    color: backgroundWhite,
                    boxShadow: [
                      BoxShadow(
                        color: Colors.grey,
                        blurRadius: 10.0,
                      )
                    ],
                  ),
                  padding: const EdgeInsets.all(paddingLeftRight),
                  width: widthScreen,
                  child: GestureDetector(
                    onTap: () {
                      String username = getCustomerName();
                      if (username != '') {
                        checkOut(context, listOrders, username);
                      } else {
                        modalInputName(context, nameController, listOrders);
                      }
                    },
                    child: ButtonComponent(
                        buttonColor: buttonColor,
                        teksButton:
                            'Pesan - Rp ${formatNumber().format(totalHarga)}'),
                  ),
                ),
              )
            ],
          ),
        );
      },
    );
  }

  Column listWithVariant(List<Orders> listOrders, i, BuildContext context,
      List<dynamic> indexAdaVariant) {
    // dippecah lagi masing2 indexnya
    int indexOrder = int.parse(i.split('|')[0]);
    int indexOrderDetail = int.parse(i.split('|')[1]);

    List<String> variantCaption = [];
    List<String> variantName = [];

    if (listOrders[indexOrder].orderDetail.isNotEmpty) {
      for (int y = 0;
          y <
              listOrders[indexOrder]
                  .orderDetail[indexOrderDetail]
                  .orderVariant
                  .length;
          y++) {
        int indexCaption = variantCaption.indexWhere((element) =>
            element ==
            listOrders[indexOrder]
                .orderDetail[indexOrderDetail]
                .orderVariant[y]
                .caption);
        if (indexCaption == -1) {
          variantCaption.add(listOrders[indexOrder]
              .orderDetail[indexOrderDetail]
              .orderVariant[y]
              .caption);
          variantName.add(listOrders[indexOrder]
              .orderDetail[indexOrderDetail]
              .orderVariant[y]
              .name);
        } else {
          variantName[indexCaption] +=
              ", ${listOrders[indexOrder].orderDetail[indexOrderDetail].orderVariant[y].name}";
        }
      }
    }
    return Column(
      children: [
        Container(
          width: double.infinity,
          padding: const EdgeInsets.symmetric(
            horizontal: paddingLeftRight,
            vertical: 16,
          ),
          color: backgroundWhite,
          child: Row(
            crossAxisAlignment: CrossAxisAlignment.center,
            mainAxisAlignment: MainAxisAlignment.start,
            children: [
              (listOrders[indexOrder].imageUrl != '')
                  ? Image(
                      width: 80,
                      height: 80,
                      fit: BoxFit.fill,
                      image: NetworkImage(listOrders[indexOrder].imageUrl),
                    )
                  : const Image(
                      width: 80,
                      height: 80,
                      fit: BoxFit.fill,
                      image: AssetImage('assets/noimage.png'),
                    ),
              const SizedBox(
                width: 12,
              ),
              Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  defaultText(
                    context,
                    listOrders[indexOrder].namaMenu,
                    maxLines: 2,
                    overFlow: TextOverflow.ellipsis,
                    style: menuNameListViewBill(),
                  ),
                  const SizedBox(
                    height: 6,
                  ),
                  defaultText(
                    context,
                    '${listOrders[indexOrder].orderDetail[indexOrderDetail].totalItem} X Rp ${formatNumber().format(listOrders[indexOrder].satuanHarga)}',
                    style: viewbillStyle(
                      font: 12,
                      fontWeight: FontWeight.w300,
                    ),
                  ),
                  const SizedBox(
                    height: 6,
                  ),
                  (listOrders[indexOrder].orderDetail[indexOrderDetail].note !=
                          '')
                      ? defaultText(
                          context,
                          "Catatan: ${listOrders[indexOrder].orderDetail[indexOrderDetail].note}",
                          maxLines: 2,
                          overFlow: TextOverflow.ellipsis,
                          style: viewbillStyle(
                            font: 12,
                            fontWeight: FontWeight.w300,
                          ),
                        )
                      : const SizedBox(),
                  for (int a = 0; a < variantCaption.length; a++)
                    if (variantCaption[a] != '')
                      // defaultText(
                      //   context,
                      //   listOrders[i]
                      //       .orderDetail[0]
                      //       .orderVariant[a]
                      //       .name,
                      //   maxLines: 2,
                      //   overFlow:
                      //       TextOverflow.ellipsis,
                      //   style: viewbillStyle(
                      //     font: 12,
                      //     fontWeight:
                      //         FontWeight.w300,
                      //   ),
                      // ),
                      Row(
                        children: [
                          defaultText(
                            context,
                            "${variantCaption[a]} : ",
                            maxLines: 2,
                            overFlow: TextOverflow.ellipsis,
                            style: viewbillStyle(
                              font: 12,
                              fontWeight: FontWeight.w300,
                            ),
                          ),
                          defaultText(
                            context,
                            variantName[a],
                            maxLines: 2,
                            overFlow: TextOverflow.ellipsis,
                            style: viewbillStyle(
                              font: 12,
                              fontWeight: FontWeight.w300,
                            ),
                          ),
                        ],
                      )
                ],
              )
            ],
          ),
        ),
        const SizedBox(
          height: 24,
        )
      ],
    );
  }
}

Future<dynamic> modalInputName(BuildContext context,
    TextEditingController nameController, List<Orders> listOrders) {
  return showDialog(
    context: context,
    builder: (BuildContext context) {
      return CoreModalInputName(context, nameController, listOrders);
    },
  );
}

class AddMoreOrder extends StatelessWidget {
  const AddMoreOrder({
    Key? key,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      height: 80,

      width: double.infinity,
      color: backgroundWhite,
      padding: const EdgeInsets.symmetric(horizontal: paddingLeftRight),
      // color: Colors.red,
      child: Row(
        children: [
          Expanded(
            child: Container(
              child: defaultText(
                context,
                'Tambahkan menu lainnya?',
                maxLines: 2,
                overFlow: TextOverflow.ellipsis,
                style: viewbillStyle(
                  font: 16,
                  fontWeight: FontWeight.w400,
                ),
              ),
            ),
          ),
          const SizedBox(
            width: 19,
          ),
          GestureDetector(
            onTap: () {
              Navigator.pop(context);
            },
            child: Container(
              width: 98,
              height: 30,
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(21),
                color: buttonColor,
              ),
              child: Center(
                child: defaultText(
                  context,
                  'Tambah',
                  style: addButton(
                    font: 8,
                  ),
                ),
              ),
            ),
          )
        ],
      ),
    );
  }
}
