import 'package:byod/helper/widget/style.dart';
import 'package:byod/ui/viewbill/view_bill.dart';
import 'package:flutter/material.dart';

import '../../helper/helper.dart';

// ignore: must_be_immutable
class FinishOrder extends StatelessWidget {
  bool isLocked;
  FinishOrder({Key? key, this.isLocked = false}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return SafeArea(
      child: Scaffold(
        backgroundColor: backgroundColor,
        body: Center(
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              (!isLocked)
                  // ? const Icon(
                  //     Icons.check_circle,
                  //     size: 120,
                  //     color: successColor,
                  //   )
                  ? fontAwesome(
                      context,
                      checkCircleIcon,
                      checkCircleIconSize,
                      color: successColor,
                    )
                  // : Icon(
                  //     Icons.highlight_remove_outlined,
                  //     size: 120,
                  //     color: cancelColor,
                  //   ),
                  : fontAwesome(
                      context,
                      timesCircleIcon,
                      timesCircleIconSize,
                      color: dangerColor,
                    ),
              // Text(
              //   (!isLocked)
              //       ? "Orderan Telah Di Terima"
              //       : "Tidak bisa melakukan order",
              //   // style:
              //   //     const TextStyle(fontSize: 20, fontWeight: FontWeight.w600),
              //   style: textStyleMenuList(context),
              // ),
              defaultText(
                  context,
                  (!isLocked)
                      ? "Orderan Telah Diterima"
                      : "Tidak bisa melakukan order",
                  style: textStyleMenuList(context)),
              const SizedBox(height: 30),
              // Text(
              //   (!isLocked)
              //       ? "Silakan pergi ke kasir untuk melakukan pembayaran, agar orderanmu diproses"
              //       : "Silakan pergi ke kasir unutk membuka table / selesaikan orderan sebelumnya",
              //   textAlign: TextAlign.center,
              //   // style: TextStyle(fontSize: 15, fontWeight: FontWeight.w400),
              //   style: textStyleNormalFont(context),
              // ),
              defaultText(
                context,
                (!isLocked)
                    ? "Silakan pergi ke kasir untuk melakukan pembayaran, agar orderanmu diproses"
                    : "Silakan pergi ke kasir unutk membuka table / selesaikan orderan sebelumnya",
                textAlign: TextAlign.center,
                style: textStyleNormalFont(context),
              ),
              SizedBox(height: MediaQuery.of(context).size.height * 0.015),
              ElevatedButton(
                  style: ElevatedButton.styleFrom(backgroundColor: buttonColor),
                  onPressed: () {
                    // list[index].note = noteController.text;
                    Navigator.pushAndRemoveUntil(
                        context,
                        MaterialPageRoute(builder: (_) => ViewBill()),
                        (route) => false);
                  },
                  child: defaultText(context, "Kembali")),
            ],
          ),
        ),
      ),
    );
  }
}
